/*
tzar_lzss 0.1a
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org

from Tzar of HaemimontGames
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static unsigned char x0051d7a4[0x40+0x25];

static unsigned char tzar_lzss_dump[] = {
0x55,0x8b,0xec,0x8b,0x45,0x0c,0x53,0x56,0x57,0x85,0xc0,0x75,0x10,0x8b,0x45,0x14,
0xc7,0x00,0x00,0x00,0x00,0x00,0x33,0xc0,0x5f,0x5e,0x5b,0x5d,0xc3,0x8b,0x4d,0x18,
0x81,0xe1,0xff,0x00,0x00,0x00,0x8d,0x81,0x5f,0xff,0xff,0xff,0x83,0xf8,0x24,0x0f,
0x87,0xf4,0x08,0x00,0x00,0x33,0xd2,0x8a,0x90,0xe4,0xd7,0x51,0x00,0xff,0x24,0x95,
0xa4,0xd7,0x51,0x00,0x8b,0x75,0x08,0x8b,0x7d,0x10,0x33,0xc9,0x55,0x8b,0x6d,0x0c,
0x8d,0x6c,0x35,0xff,0x8b,0x06,0x0f,0xc8,0xd3,0xe0,0xd1,0xe0,0x73,0x16,0x66,0x81,
0xc1,0x01,0x20,0x83,0xd6,0x01,0x80,0xe1,0x07,0x0f,0xc8,0x88,0x07,0x47,0x3b,0xf5,
0x7c,0xe2,0xeb,0x56,0x66,0x81,0xc1,0x04,0x80,0x83,0xd6,0x01,0x80,0xe1,0x07,0x8b,
0xd8,0xc1,0xeb,0x16,0x75,0x12,0x25,0x00,0x00,0x20,0x00,0xc1,0xe8,0x15,0x8d,0x7c,
0x07,0x02,0x3b,0xf5,0x7c,0xbe,0xeb,0x32,0x25,0x00,0x00,0x20,0x00,0xc1,0xe8,0x16,
0x73,0x0a,0x8a,0x94,0x1f,0x00,0xfc,0xff,0xff,0x88,0x17,0x47,0x40,0x8a,0x94,0x1f,
0x00,0xfc,0xff,0xff,0x88,0x17,0x8a,0x94,0x1f,0x01,0xfc,0xff,0xff,0x88,0x57,0x01,
0x83,0xc7,0x02,0x48,0x75,0xe7,0x3b,0xf5,0x7c,0x8a,0x5d,0x8b,0x75,0x10,0x2b,0xfe,
0x8b,0x75,0x14,0x89,0x3e,0x33,0xc0,0x5f,0x5e,0x5b,0x5d,0xc3,0x8b,0x75,0x08,0x8b,
0x7d,0x10,0x33,0xc9,0x55,0x8b,0x6d,0x0c,0x8d,0x6c,0x35,0xff,0x8b,0x06,0x0f,0xc8,
0xd3,0xe0,0xd1,0xe0,0x73,0x16,0x66,0x81,0xc1,0x01,0x20,0x83,0xd6,0x01,0x80,0xe1,
0x07,0x0f,0xc8,0x88,0x07,0x47,0x3b,0xf5,0x7c,0xe2,0xeb,0x56,0x66,0x81,0xc1,0x05,
0xa0,0x83,0xd6,0x01,0x80,0xe1,0x07,0x8b,0xd8,0xc1,0xeb,0x16,0x75,0x12,0x25,0x00,
0x00,0x30,0x00,0xc1,0xe8,0x14,0x8d,0x7c,0x07,0x02,0x3b,0xf5,0x7c,0xbe,0xeb,0x32,
0x25,0x00,0x00,0x30,0x00,0xc1,0xe8,0x15,0x73,0x0a,0x8a,0x94,0x1f,0x00,0xfc,0xff,
0xff,0x88,0x17,0x47,0x40,0x8a,0x94,0x1f,0x00,0xfc,0xff,0xff,0x88,0x17,0x8a,0x94,
0x1f,0x01,0xfc,0xff,0xff,0x88,0x57,0x01,0x83,0xc7,0x02,0x48,0x75,0xe7,0x3b,0xf5,
0x7c,0x8a,0x5d,0x8b,0x75,0x10,0x2b,0xfe,0x8b,0x75,0x14,0x89,0x3e,0x33,0xc0,0x5f,
0x5e,0x5b,0x5d,0xc3,0x8b,0x75,0x08,0x8b,0x7d,0x10,0x33,0xc9,0x55,0x8b,0x6d,0x0c,
0x8d,0x6c,0x35,0xff,0x8b,0x06,0x0f,0xc8,0xd3,0xe0,0xd1,0xe0,0x73,0x16,0x66,0x81,
0xc1,0x01,0x20,0x83,0xd6,0x01,0x80,0xe1,0x07,0x0f,0xc8,0x88,0x07,0x47,0x3b,0xf5,
0x7c,0xe2,0xeb,0x56,0x66,0x81,0xc1,0x06,0xc0,0x83,0xd6,0x01,0x80,0xe1,0x07,0x8b,
0xd8,0xc1,0xeb,0x16,0x75,0x12,0x25,0x00,0x00,0x38,0x00,0xc1,0xe8,0x13,0x8d,0x7c,
0x07,0x02,0x3b,0xf5,0x7c,0xbe,0xeb,0x32,0x25,0x00,0x00,0x38,0x00,0xc1,0xe8,0x14,
0x73,0x0a,0x8a,0x94,0x1f,0x00,0xfc,0xff,0xff,0x88,0x17,0x47,0x40,0x8a,0x94,0x1f,
0x00,0xfc,0xff,0xff,0x88,0x17,0x8a,0x94,0x1f,0x01,0xfc,0xff,0xff,0x88,0x57,0x01,
0x83,0xc7,0x02,0x48,0x75,0xe7,0x3b,0xf5,0x7c,0x8a,0x5d,0x8b,0x75,0x10,0x2b,0xfe,
0x8b,0x75,0x14,0x89,0x3e,0x33,0xc0,0x5f,0x5e,0x5b,0x5d,0xc3,0x8b,0x75,0x08,0x8b,
0x7d,0x10,0x33,0xc9,0x55,0x8b,0x6d,0x0c,0x8d,0x6c,0x35,0xff,0x8b,0x06,0x0f,0xc8,
0xd3,0xe0,0xd1,0xe0,0x73,0x16,0x66,0x81,0xc1,0x01,0x20,0x83,0xd6,0x01,0x80,0xe1,
0x07,0x0f,0xc8,0x88,0x07,0x47,0x3b,0xf5,0x7c,0xe2,0xeb,0x56,0x66,0x81,0xc1,0x07,
0xe0,0x83,0xd6,0x01,0x80,0xe1,0x07,0x8b,0xd8,0xc1,0xeb,0x16,0x75,0x12,0x25,0x00,
0x00,0x3c,0x00,0xc1,0xe8,0x12,0x8d,0x7c,0x07,0x02,0x3b,0xf5,0x7c,0xbe,0xeb,0x32,
0x25,0x00,0x00,0x3c,0x00,0xc1,0xe8,0x13,0x73,0x0a,0x8a,0x94,0x1f,0x00,0xfc,0xff,
0xff,0x88,0x17,0x47,0x40,0x8a,0x94,0x1f,0x00,0xfc,0xff,0xff,0x88,0x17,0x8a,0x94,
0x1f,0x01,0xfc,0xff,0xff,0x88,0x57,0x01,0x83,0xc7,0x02,0x48,0x75,0xe7,0x3b,0xf5,
0x7c,0x8a,0x5d,0x8b,0x75,0x10,0x2b,0xfe,0x8b,0x75,0x14,0x89,0x3e,0x33,0xc0,0x5f,
0x5e,0x5b,0x5d,0xc3,0x8b,0x75,0x08,0x8b,0x7d,0x10,0x33,0xc9,0x55,0x8b,0x6d,0x0c,
0x8d,0x6c,0x35,0xff,0x8b,0x06,0x0f,0xc8,0xd3,0xe0,0xd1,0xe0,0x73,0x16,0x66,0x81,
0xc1,0x01,0x20,0x83,0xd6,0x01,0x80,0xe1,0x07,0x0f,0xc8,0x88,0x07,0x47,0x3b,0xf5,
0x7c,0xe2,0xeb,0x55,0x66,0x83,0xc1,0x00,0x83,0xd6,0x02,0x80,0xe1,0x07,0x8b,0xd8,
0xc1,0xeb,0x16,0x75,0x12,0x25,0x00,0x00,0x3e,0x00,0xc1,0xe8,0x11,0x8d,0x7c,0x07,
0x02,0x3b,0xf5,0x7c,0xbf,0xeb,0x32,0x25,0x00,0x00,0x3e,0x00,0xc1,0xe8,0x12,0x73,
0x0a,0x8a,0x94,0x1f,0x00,0xfc,0xff,0xff,0x88,0x17,0x47,0x40,0x8a,0x94,0x1f,0x00,
0xfc,0xff,0xff,0x88,0x17,0x8a,0x94,0x1f,0x01,0xfc,0xff,0xff,0x88,0x57,0x01,0x83,
0xc7,0x02,0x48,0x75,0xe7,0x3b,0xf5,0x7c,0x8b,0x5d,0x8b,0x75,0x10,0x2b,0xfe,0x8b,
0x75,0x14,0x89,0x3e,0x33,0xc0,0x5f,0x5e,0x5b,0x5d,0xc3,0x8b,0x75,0x08,0x8b,0x7d,
0x10,0x33,0xc9,0x55,0x8b,0x6d,0x0c,0x8d,0x6c,0x35,0xff,0x8b,0x06,0x0f,0xc8,0xd3,
0xe0,0xd1,0xe0,0x73,0x16,0x66,0x81,0xc1,0x01,0x20,0x83,0xd6,0x01,0x80,0xe1,0x07,
0x0f,0xc8,0x88,0x07,0x47,0x3b,0xf5,0x7c,0xe2,0xeb,0x56,0x66,0x81,0xc1,0x05,0xa0,
0x83,0xd6,0x01,0x80,0xe1,0x07,0x8b,0xd8,0xc1,0xeb,0x15,0x75,0x12,0x25,0x00,0x00,
0x10,0x00,0xc1,0xe8,0x14,0x8d,0x7c,0x07,0x02,0x3b,0xf5,0x7c,0xbe,0xeb,0x32,0x25,
0x00,0x00,0x10,0x00,0xc1,0xe8,0x15,0x73,0x0a,0x8a,0x94,0x1f,0x00,0xf8,0xff,0xff,
0x88,0x17,0x47,0x40,0x8a,0x94,0x1f,0x00,0xf8,0xff,0xff,0x88,0x17,0x8a,0x94,0x1f,
0x01,0xf8,0xff,0xff,0x88,0x57,0x01,0x83,0xc7,0x02,0x48,0x75,0xe7,0x3b,0xf5,0x7c,
0x8a,0x5d,0x8b,0x75,0x10,0x2b,0xfe,0x8b,0x75,0x14,0x89,0x3e,0x33,0xc0,0x5f,0x5e,
0x5b,0x5d,0xc3,0x8b,0x75,0x08,0x8b,0x7d,0x10,0x33,0xc9,0x55,0x8b,0x6d,0x0c,0x8d,
0x6c,0x35,0xff,0x8b,0x06,0x0f,0xc8,0xd3,0xe0,0xd1,0xe0,0x73,0x16,0x66,0x81,0xc1,
0x01,0x20,0x83,0xd6,0x01,0x80,0xe1,0x07,0x0f,0xc8,0x88,0x07,0x47,0x3b,0xf5,0x7c,
0xe2,0xeb,0x56,0x66,0x81,0xc1,0x06,0xc0,0x83,0xd6,0x01,0x80,0xe1,0x07,0x8b,0xd8,
0xc1,0xeb,0x15,0x75,0x12,0x25,0x00,0x00,0x18,0x00,0xc1,0xe8,0x13,0x8d,0x7c,0x07,
0x02,0x3b,0xf5,0x7c,0xbe,0xeb,0x32,0x25,0x00,0x00,0x18,0x00,0xc1,0xe8,0x14,0x73,
0x0a,0x8a,0x94,0x1f,0x00,0xf8,0xff,0xff,0x88,0x17,0x47,0x40,0x8a,0x94,0x1f,0x00,
0xf8,0xff,0xff,0x88,0x17,0x8a,0x94,0x1f,0x01,0xf8,0xff,0xff,0x88,0x57,0x01,0x83,
0xc7,0x02,0x48,0x75,0xe7,0x3b,0xf5,0x7c,0x8a,0x5d,0x8b,0x75,0x10,0x2b,0xfe,0x8b,
0x75,0x14,0x89,0x3e,0x33,0xc0,0x5f,0x5e,0x5b,0x5d,0xc3,0x8b,0x75,0x08,0x8b,0x7d,
0x10,0x33,0xc9,0x55,0x8b,0x6d,0x0c,0x8d,0x6c,0x35,0xff,0x8b,0x06,0x0f,0xc8,0xd3,
0xe0,0xd1,0xe0,0x73,0x16,0x66,0x81,0xc1,0x01,0x20,0x83,0xd6,0x01,0x80,0xe1,0x07,
0x0f,0xc8,0x88,0x07,0x47,0x3b,0xf5,0x7c,0xe2,0xeb,0x56,0x66,0x81,0xc1,0x07,0xe0,
0x83,0xd6,0x01,0x80,0xe1,0x07,0x8b,0xd8,0xc1,0xeb,0x15,0x75,0x12,0x25,0x00,0x00,
0x1c,0x00,0xc1,0xe8,0x12,0x8d,0x7c,0x07,0x02,0x3b,0xf5,0x7c,0xbe,0xeb,0x32,0x25,
0x00,0x00,0x1c,0x00,0xc1,0xe8,0x13,0x73,0x0a,0x8a,0x94,0x1f,0x00,0xf8,0xff,0xff,
0x88,0x17,0x47,0x40,0x8a,0x94,0x1f,0x00,0xf8,0xff,0xff,0x88,0x17,0x8a,0x94,0x1f,
0x01,0xf8,0xff,0xff,0x88,0x57,0x01,0x83,0xc7,0x02,0x48,0x75,0xe7,0x3b,0xf5,0x7c,
0x8a,0x5d,0x8b,0x75,0x10,0x2b,0xfe,0x8b,0x75,0x14,0x89,0x3e,0x33,0xc0,0x5f,0x5e,
0x5b,0x5d,0xc3,0x8b,0x75,0x08,0x8b,0x7d,0x10,0x33,0xc9,0x55,0x8b,0x6d,0x0c,0x8d,
0x6c,0x35,0xff,0x8b,0x06,0x0f,0xc8,0xd3,0xe0,0xd1,0xe0,0x73,0x16,0x66,0x81,0xc1,
0x01,0x20,0x83,0xd6,0x01,0x80,0xe1,0x07,0x0f,0xc8,0x88,0x07,0x47,0x3b,0xf5,0x7c,
0xe2,0xeb,0x55,0x66,0x83,0xc1,0x00,0x83,0xd6,0x02,0x80,0xe1,0x07,0x8b,0xd8,0xc1,
0xeb,0x15,0x75,0x12,0x25,0x00,0x00,0x1e,0x00,0xc1,0xe8,0x11,0x8d,0x7c,0x07,0x02,
0x3b,0xf5,0x7c,0xbf,0xeb,0x32,0x25,0x00,0x00,0x1e,0x00,0xc1,0xe8,0x12,0x73,0x0a,
0x8a,0x94,0x1f,0x00,0xf8,0xff,0xff,0x88,0x17,0x47,0x40,0x8a,0x94,0x1f,0x00,0xf8,
0xff,0xff,0x88,0x17,0x8a,0x94,0x1f,0x01,0xf8,0xff,0xff,0x88,0x57,0x01,0x83,0xc7,
0x02,0x48,0x75,0xe7,0x3b,0xf5,0x7c,0x8b,0x5d,0x8b,0x75,0x10,0x2b,0xfe,0x8b,0x75,
0x14,0x89,0x3e,0x33,0xc0,0x5f,0x5e,0x5b,0x5d,0xc3,0x8b,0x75,0x08,0x8b,0x7d,0x10,
0x33,0xc9,0x55,0x8b,0x6d,0x0c,0x8d,0x6c,0x35,0xff,0x8b,0x06,0x0f,0xc8,0xd3,0xe0,
0xd1,0xe0,0x73,0x16,0x66,0x81,0xc1,0x01,0x20,0x83,0xd6,0x01,0x80,0xe1,0x07,0x0f,
0xc8,0x88,0x07,0x47,0x3b,0xf5,0x7c,0xe2,0xeb,0x56,0x66,0x81,0xc1,0x01,0x20,0x83,
0xd6,0x02,0x80,0xe1,0x07,0x8b,0xd8,0xc1,0xeb,0x15,0x75,0x12,0x25,0x00,0x00,0x1f,
0x00,0xc1,0xe8,0x10,0x8d,0x7c,0x07,0x02,0x3b,0xf5,0x7c,0xbe,0xeb,0x32,0x25,0x00,
0x00,0x1f,0x00,0xc1,0xe8,0x11,0x73,0x0a,0x8a,0x94,0x1f,0x00,0xf8,0xff,0xff,0x88,
0x17,0x47,0x40,0x8a,0x94,0x1f,0x00,0xf8,0xff,0xff,0x88,0x17,0x8a,0x94,0x1f,0x01,
0xf8,0xff,0xff,0x88,0x57,0x01,0x83,0xc7,0x02,0x48,0x75,0xe7,0x3b,0xf5,0x7c,0x8a,
0x5d,0x8b,0x75,0x10,0x2b,0xfe,0x8b,0x75,0x14,0x89,0x3e,0x33,0xc0,0x5f,0x5e,0x5b,
0x5d,0xc3,0x8b,0x75,0x08,0x8b,0x7d,0x10,0x33,0xc9,0x55,0x8b,0x6d,0x0c,0x8d,0x6c,
0x35,0xff,0x8b,0x06,0x0f,0xc8,0xd3,0xe0,0xd1,0xe0,0x73,0x16,0x66,0x81,0xc1,0x01,
0x20,0x83,0xd6,0x01,0x80,0xe1,0x07,0x0f,0xc8,0x88,0x07,0x47,0x3b,0xf5,0x7c,0xe2,
0xeb,0x56,0x66,0x81,0xc1,0x06,0xc0,0x83,0xd6,0x01,0x80,0xe1,0x07,0x8b,0xd8,0xc1,
0xeb,0x14,0x75,0x12,0x25,0x00,0x00,0x08,0x00,0xc1,0xe8,0x13,0x8d,0x7c,0x07,0x02,
0x3b,0xf5,0x7c,0xbe,0xeb,0x32,0x25,0x00,0x00,0x08,0x00,0xc1,0xe8,0x14,0x73,0x0a,
0x8a,0x94,0x1f,0x00,0xf0,0xff,0xff,0x88,0x17,0x47,0x40,0x8a,0x94,0x1f,0x00,0xf0,
0xff,0xff,0x88,0x17,0x8a,0x94,0x1f,0x01,0xf0,0xff,0xff,0x88,0x57,0x01,0x83,0xc7,
0x02,0x48,0x75,0xe7,0x3b,0xf5,0x7c,0x8a,0x5d,0x8b,0x75,0x10,0x2b,0xfe,0x8b,0x75,
0x14,0x89,0x3e,0x33,0xc0,0x5f,0x5e,0x5b,0x5d,0xc3,0x8b,0x75,0x08,0x8b,0x7d,0x10,
0x33,0xc9,0x55,0x8b,0x6d,0x0c,0x8d,0x6c,0x35,0xff,0x8b,0x06,0x0f,0xc8,0xd3,0xe0,
0xd1,0xe0,0x73,0x16,0x66,0x81,0xc1,0x01,0x20,0x83,0xd6,0x01,0x80,0xe1,0x07,0x0f,
0xc8,0x88,0x07,0x47,0x3b,0xf5,0x7c,0xe2,0xeb,0x56,0x66,0x81,0xc1,0x07,0xe0,0x83,
0xd6,0x01,0x80,0xe1,0x07,0x8b,0xd8,0xc1,0xeb,0x14,0x75,0x12,0x25,0x00,0x00,0x0c,
0x00,0xc1,0xe8,0x12,0x8d,0x7c,0x07,0x02,0x3b,0xf5,0x7c,0xbe,0xeb,0x32,0x25,0x00,
0x00,0x0c,0x00,0xc1,0xe8,0x13,0x73,0x0a,0x8a,0x94,0x1f,0x00,0xf0,0xff,0xff,0x88,
0x17,0x47,0x40,0x8a,0x94,0x1f,0x00,0xf0,0xff,0xff,0x88,0x17,0x8a,0x94,0x1f,0x01,
0xf0,0xff,0xff,0x88,0x57,0x01,0x83,0xc7,0x02,0x48,0x75,0xe7,0x3b,0xf5,0x7c,0x8a,
0x5d,0x8b,0x75,0x10,0x2b,0xfe,0x8b,0x75,0x14,0x89,0x3e,0x33,0xc0,0x5f,0x5e,0x5b,
0x5d,0xc3,0x8b,0x75,0x08,0x8b,0x7d,0x10,0x33,0xc9,0x55,0x8b,0x6d,0x0c,0x8d,0x6c,
0x35,0xff,0x8b,0x06,0x0f,0xc8,0xd3,0xe0,0xd1,0xe0,0x73,0x16,0x66,0x81,0xc1,0x01,
0x20,0x83,0xd6,0x01,0x80,0xe1,0x07,0x0f,0xc8,0x88,0x07,0x47,0x3b,0xf5,0x7c,0xe2,
0xeb,0x55,0x66,0x83,0xc1,0x00,0x83,0xd6,0x02,0x80,0xe1,0x07,0x8b,0xd8,0xc1,0xeb,
0x14,0x75,0x12,0x25,0x00,0x00,0x0e,0x00,0xc1,0xe8,0x11,0x8d,0x7c,0x07,0x02,0x3b,
0xf5,0x7c,0xbf,0xeb,0x32,0x25,0x00,0x00,0x0e,0x00,0xc1,0xe8,0x12,0x73,0x0a,0x8a,
0x94,0x1f,0x00,0xf0,0xff,0xff,0x88,0x17,0x47,0x40,0x8a,0x94,0x1f,0x00,0xf0,0xff,
0xff,0x88,0x17,0x8a,0x94,0x1f,0x01,0xf0,0xff,0xff,0x88,0x57,0x01,0x83,0xc7,0x02,
0x48,0x75,0xe7,0x3b,0xf5,0x7c,0x8b,0x5d,0x8b,0x75,0x10,0x2b,0xfe,0x8b,0x75,0x14,
0x89,0x3e,0x33,0xc0,0x5f,0x5e,0x5b,0x5d,0xc3,0x8b,0x75,0x08,0x8b,0x7d,0x10,0x33,
0xc9,0x55,0x8b,0x6d,0x0c,0x8d,0x6c,0x35,0xff,0x8b,0x06,0x0f,0xc8,0xd3,0xe0,0xd1,
0xe0,0x73,0x16,0x66,0x81,0xc1,0x01,0x20,0x83,0xd6,0x01,0x80,0xe1,0x07,0x0f,0xc8,
0x88,0x07,0x47,0x3b,0xf5,0x7c,0xe2,0xeb,0x56,0x66,0x81,0xc1,0x01,0x20,0x83,0xd6,
0x02,0x80,0xe1,0x07,0x8b,0xd8,0xc1,0xeb,0x14,0x75,0x12,0x25,0x00,0x00,0x0f,0x00,
0xc1,0xe8,0x10,0x8d,0x7c,0x07,0x02,0x3b,0xf5,0x7c,0xbe,0xeb,0x32,0x25,0x00,0x00,
0x0f,0x00,0xc1,0xe8,0x11,0x73,0x0a,0x8a,0x94,0x1f,0x00,0xf0,0xff,0xff,0x88,0x17,
0x47,0x40,0x8a,0x94,0x1f,0x00,0xf0,0xff,0xff,0x88,0x17,0x8a,0x94,0x1f,0x01,0xf0,
0xff,0xff,0x88,0x57,0x01,0x83,0xc7,0x02,0x48,0x75,0xe7,0x3b,0xf5,0x7c,0x8a,0x5d,
0x8b,0x75,0x10,0x2b,0xfe,0x8b,0x75,0x14,0x89,0x3e,0x33,0xc0,0x5f,0x5e,0x5b,0x5d,
0xc3,0x8b,0x75,0x08,0x8b,0x7d,0x10,0x33,0xc9,0x55,0x8b,0x6d,0x0c,0x8d,0x6c,0x35,
0xff,0x8b,0x06,0x0f,0xc8,0xd3,0xe0,0xd1,0xe0,0x73,0x16,0x66,0x81,0xc1,0x01,0x20,
0x83,0xd6,0x01,0x80,0xe1,0x07,0x0f,0xc8,0x88,0x07,0x47,0x3b,0xf5,0x7c,0xe2,0xeb,
0x56,0x66,0x81,0xc1,0x02,0x40,0x83,0xd6,0x02,0x80,0xe1,0x07,0x8b,0xd8,0xc1,0xeb,
0x14,0x75,0x12,0x25,0x00,0x80,0x0f,0x00,0xc1,0xe8,0x0f,0x8d,0x7c,0x07,0x02,0x3b,
0xf5,0x7c,0xbe,0xeb,0x32,0x25,0x00,0x80,0x0f,0x00,0xc1,0xe8,0x10,0x73,0x0a,0x8a,
0x94,0x1f,0x00,0xf0,0xff,0xff,0x88,0x17,0x47,0x40,0x8a,0x94,0x1f,0x00,0xf0,0xff,
0xff,0x88,0x17,0x8a,0x94,0x1f,0x01,0xf0,0xff,0xff,0x88,0x57,0x01,0x83,0xc7,0x02,
0x48,0x75,0xe7,0x3b,0xf5,0x7c,0x8a,0x5d,0x8b,0x75,0x10,0x2b,0xfe,0x8b,0x75,0x14,
0x89,0x3e,0x33,0xc0,0x5f,0x5e,0x5b,0x5d,0xc3,0xa1,0x5c,0x6b,0x59,0x00,0x5f,0x5e,
0x5b,0x5d,0xc3,0x90,0xcc};

int __cdecl (*tzar_lzss)(unsigned char *in, int insz, unsigned char *out, int *outsz, int algo) = NULL;



// anti DEP limitation! if you apply VirtualAlloc on a static char
// it will cover also the rest of the page included other variables!
void *tzar_lzss_alloc(u8 *dump, int dumpsz) {
    int     pagesz;
    void    *ret;

    pagesz = (dumpsz + 4095) & (~4095); // useful for pages? mah

#ifdef WIN32
    ret = VirtualAlloc(
        NULL,
        pagesz,
        MEM_COMMIT | MEM_RESERVE,
        PAGE_EXECUTE_READWRITE);    // write for memcpy
#else
    ret = malloc(pagesz);
    mprotect(
        ret,
        pagesz,
        PROT_EXEC | PROT_WRITE);    // write for memcpy
#endif
    memcpy(ret, dump, dumpsz);
    return(ret);
}



void tzar_lzss_init(void) {
    if(tzar_lzss) return;
    unsigned char   **p,
                    *func;

    func = (unsigned char *)tzar_lzss_alloc(tzar_lzss_dump, sizeof(tzar_lzss_dump));

    #define PATCHIT(X,Y) *(int *)(func + X) = (int)(Y);
    PATCHIT(0x00000039, x0051d7a4 + 0x00000040) // mov dl, byte ptr [eax+51D7E4]
    PATCHIT(0x00000040, x0051d7a4 + 0x00000000) // jmp dword ptr [edx*4+51D7A4]
    //PATCHIT(0x0000092a, x00596b5c + 0x00000000) // mov eax, dword ptr [596B5C]
    #undef PATCHIT

    p = (unsigned char **)x0051d7a4;
    *p++ = func + 0x00000044;
    *p++ = func + 0x000000dc;
    *p++ = func + 0x00000174;
    *p++ = func + 0x0000020c;
    *p++ = func + 0x000002a4;
    *p++ = func + 0x0000033b;
    *p++ = func + 0x000003d3;
    *p++ = func + 0x0000046b;
    *p++ = func + 0x00000503;
    *p++ = func + 0x0000059a;
    *p++ = func + 0x00000632;
    *p++ = func + 0x000006ca;
    *p++ = func + 0x00000762;
    *p++ = func + 0x000007f9;
    *p++ = func + 0x00000891;
    *p++ = func + 0x00000929;
    memcpy(x0051d7a4 + 0x00000040, "\x00\x01\x02\x03\x04\x0F\x0F\x0F\x0F\x0F\x0F\x0F\x0F\x0F\x0F\x0F\x05\x06\x07\x08\x09\x0F\x0F\x0F\x0F\x0F\x0F\x0F\x0F\x0F\x0F\x0F\x0A\x0B\x0C\x0D\x0E", 0x25);
    memcpy(func + 0x00000929, "\x33\xc0\x90\x90\x90", 5);   // mov eax, dword ptr [596B5C]

    tzar_lzss = (void *)func;
}

