/*
unlz2k 0.1b
by Luigi Auriemma
e-mail: aluigi@autistici.org
web:    aluigi.org

original LZ2K decompression function from the game Transformers
it should be related to nu2api used in the games developed by Traveller's Tales
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


static unsigned char *x006f5bd0 = NULL;
static unsigned char *x02c1fde0 = NULL;
static unsigned char unlz2k_dump[] =
"\x55\x8b\x2d\xe0\xfd\xc1\x02\x56\x33\xf6\x4d\x89\x2d\xe0\xfd\xc1"
"\x02\x78\x2d\xa1\xe8\x1d\xc2\x02\xeb\x06\x8d\x9b\x00\x00\x00\x00"
"\x8a\x0c\x38\x40\x25\xff\x1f\x00\x00\x88\x0c\x3e\x46\x3b\xf3\x74"
"\x75\x4d\x79\xec\x89\x2d\xe0\xfd\xc1\x02\xa3\xe8\x1d\xc2\x02\x90"
"\xe8\xeb\x0d\x00\x00\x3d\xff\x00\x00\x00\x77\x0b\x88\x04\x3e\x46"
"\x3b\xf3\x75\xec\x5e\x5d\xc3\x05\x03\xff\xff\xff\xa3\xe0\xfd\xc1"
"\x02\xe8\x6a\x0e\x00\x00\x8b\x0d\xe0\xfd\xc1\x02\x8b\xd0\x8b\xc6"
"\x2b\xc2\x48\x25\xff\x1f\x00\x00\x49\xa3\xe8\x1d\xc2\x02\x89\x0d"
"\xe0\xfd\xc1\x02\x78\xba\x8a\x0c\x38\x40\x25\xff\x1f\x00\x00\x88"
"\x0c\x3e\x46\x3b\xf3\xa3\xe8\x1d\xc2\x02\x74\x15\xff\x0d\xe0\xfd"
"\xc1\x02\x79\xe2\xeb\x9a\x89\x2d\xe0\xfd\xc1\x02\xa3\xe8\x1d\xc2"
"\x02\x5e\x5d\xc3\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc"
"\xa1\xd0\x5b\x6f\x00\x55\x33\xed\x3b\xc5\x75\x04\x33\xc0\x5d\xc3"
"\x8b\x44\x24\x08\x8b\x4c\x24\x0c\x8b\x54\x24\x14\xa3\xd8\xe6\xc4"
"\x02\x8b\x44\x24\x10\x89\x0d\xdc\xe6\xc4\x02\x89\x15\xe8\xe6\xc4"
"\x02\xa3\xe4\xe6\xc4\x02\xe8\x45\x0e\x00\x00\xa1\xe8\xe6\xc4\x02"
"\x3b\xc5\x89\x2d\xe0\xfd\xc1\x02\x74\x59\x53\x56\x57\x8d\x49\x00"
"\x3d\x00\x20\x00\x00\xbb\x00\x20\x00\x00\x77\x02\x8b\xd8\xbf\xe8"
"\xfd\xc1\x02\xe8\xd8\xfe\xff\xff\x8b\xf7\x8b\x3d\xdc\xe6\xc4\x02"
"\x8b\xcb\x8b\xd1\xc1\xe9\x02\xf3\xa5\x8b\xca\x83\xe1\x03\xf3\xa4"
"\xa1\xe8\xe6\xc4\x02\x8b\x3d\xdc\xe6\xc4\x02\x2b\xc3\x03\xfb\x03"
"\xeb\x85\xc0\x89\x3d\xdc\xe6\xc4\x02\xa3\xe8\xe6\xc4\x02\x75\xb0"
"\x5f\x5e\x5b\x8b\xc5\x5d\xc3\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc"
"\x0f\xbe\xc0\x83\xc0\xd0\x83\xf8\x36\x77\x14\x0f\xb6\x80\x2c\x3d"
"\x66\x00\xff\x24\x85\x24\x3d\x66\x00\xb8\x01\x00\x00\x00\xc3\x33"
"\xc0\xc3\x8b\xff\x19\x3d\x66\x00\x1f\x3d\x66\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00"
"\x00\x00\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01"
"\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00"
"\x00\x00\x00\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc"
"\x0f\xbe\xc9\x8d\x41\xd0\x83\xf8\x36\x77\x16\x0f\xb6\x90\xa4\x3d"
"\x66\x00\xff\x24\x95\x94\x3d\x66\x00\x8d\x41\xa9\xc3\x8d\x41\xc9"
"\xc3\x33\xc0\xc3\x93\x3d\x66\x00\x8d\x3d\x66\x00\x89\x3d\x66\x00"
"\x91\x3d\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x03"
"\x03\x03\x03\x03\x03\x01\x01\x01\x01\x01\x01\x03\x03\x03\x03\x03"
"\x03\x03\x03\x03\x03\x03\x03\x03\x03\x03\x03\x03\x03\x03\x03\x03"
"\x03\x03\x03\x03\x03\x02\x02\x02\x02\x02\x02\xcc\xcc\xcc\xcc\xcc"
"\x81\xec\x04\x01\x00\x00\xa1\x40\x5c\x6f\x00\x8b\x4e\x0c\x89\x84"
"\x24\x00\x01\x00\x00\x8b\x46\x08\x8a\x14\x08\x53\x33\xdb\x3a\xd3"
"\x74\x22\x8b\x56\x08\x8b\x46\x0c\x8a\x0c\x10\x03\xc2\x80\xf9\x20"
"\x74\x05\x80\xf9\x09\x75\x27\xfe\x00\x8b\x4e\x08\x8b\x56\x0c\x38"
"\x1c\x11\x75\xde\xc7\x06\x07\x00\x00\x00\x5b\x8b\x8c\x24\x00\x01"
"\x00\x00\xe8\x61\x2d\x00\x00\x81\xc4\x04\x01\x00\x00\xc3\x8b\x46"
"\x0c\x57\x8b\x7e\x08\x8a\x0c\x07\x0f\xbe\xd1\x83\xc2\xdf\x83\xfa"
"\x5d\x0f\x87\xb5\x02\x00\x00\x0f\xb6\x92\x1c\x42\x66\x00\xff\x24"
"\x95\xcc\x41\x66\x00\x5f\xc7\x06\x07\x00\x00\x00\x5b\x8b\x8c\x24"
"\x00\x01\x00\x00\xe8\x1f\x2d\x00\x00\x81\xc4\x04\x01\x00\x00\xc3"
"\x40\x5f\x89\x1e\x89\x46\x0c\x5b\x8b\x8c\x24\x00\x01\x00\x00\xe8"
"\x04\x2d\x00\x00\x81\xc4\x04\x01\x00\x00\xc3\x40\x5f\xc7\x06\x01"
"\x00\x00\x00\x89\x46\x0c\x5b\x8b\x8c\x24\x00\x01\x00\x00\xe8\xe5"
"\x2c\x00\x00\x81\xc4\x04\x01\x00\x00\xc3\x40\x5f\xc7\x06\x02\x00"
"\x00\x00\x89\x46\x0c\x5b\x8b\x8c\x24\x00\x01\x00\x00\xe8\xc6\x2c"
"\x00\x00\x81\xc4\x04\x01\x00\x00\xc3\x40\x5f\xc7\x06\x03\x00\x00"
"\x00\x89\x46\x0c\x5b\x8b\x8c\x24\x00\x01\x00\x00\xe8\xa7\x2c\x00"
"\x00\x81\xc4\x04\x01\x00\x00\xc3\x40\x5f\xc7\x06\x04\x00\x00\x00"
"\x89\x46\x0c\x5b\x8b\x8c\x24\x00\x01\x00\x00\xe8\x88\x2c\x00\x00"
"\x81\xc4\x04\x01\x00\x00\xc3\x40\x5f\xc7\x06\x05\x00\x00\x00\x89"
"\x46\x0c\x5b\x8b\x8c\x24\x00\x01\x00\x00\xe8\x69\x2c\x00\x00\x81"
"\xc4\x04\x01\x00\x00\xc3\x40\x5f\xc7\x06\x06\x00\x00\x00\x89\x46"
"\x0c\x5b\x8b\x8c\x24\x00\x01\x00\x00\xe8\x4a\x2c\x00\x00\x81\xc4"
"\x04\x01\x00\x00\xc3\x40\xc7\x06\x09\x00\x00\x00\x89\x46\x0c\x80"
"\x3c\x38\x7c\x0f\x85\xa3\x01\x00\x00\x40\x5f\xc7\x06\x0d\x00\x00"
"\x00\x89\x46\x0c\x5b\x8b\x8c\x24\x00\x01\x00\x00\xe8\x17\x2c\x00"
"\x00\x81\xc4\x04\x01\x00\x00\xc3\x40\xc7\x06\x0a\x00\x00\x00\x89"
"\x46\x0c\x80\x3c\x38\x26\x0f\x85\x70\x01\x00\x00\x40\x5f\xc7\x06"
"\x0e\x00\x00\x00\x89\x46\x0c\x5b\x8b\x8c\x24\x00\x01\x00\x00\xe8"
"\xe4\x2b\x00\x00\x81\xc4\x04\x01\x00\x00\xc3\x40\xc7\x06\x10\x00"
"\x00\x00\x89\x46\x0c\x80\x3c\x38\x3d\x0f\x85\x3d\x01\x00\x00\x40"
"\x5f\x89\x46\x0c\x5b\x8b\x8c\x24\x00\x01\x00\x00\xe8\xb7\x2b\x00"
"\x00\x81\xc4\x04\x01\x00\x00\xc3\x40\xc7\x06\x13\x00\x00\x00\x89"
"\x46\x0c\x80\x3c\x38\x3d\x0f\x85\x10\x01\x00\x00\x40\x5f\x89\x46"
"\x0c\xc7\x06\x15\x00\x00\x00\x5b\x8b\x8c\x24\x00\x01\x00\x00\xe8"
"\x84\x2b\x00\x00\x81\xc4\x04\x01\x00\x00\xc3\x40\xc7\x06\x12\x00"
"\x00\x00\x89\x46\x0c\x80\x3c\x38\x3d\x0f\x85\xdd\x00\x00\x00\x40"
"\x5f\x89\x46\x0c\xc7\x06\x14\x00\x00\x00\x5b\x8b\x8c\x24\x00\x01"
"\x00\x00\xe8\x51\x2b\x00\x00\x81\xc4\x04\x01\x00\x00\xc3\x40\x5f"
"\xc7\x06\x0c\x00\x00\x00\x89\x46\x0c\x5b\x8b\x8c\x24\x00\x01\x00"
"\x00\xe8\x32\x2b\x00\x00\x81\xc4\x04\x01\x00\x00\xc3\x40\xc7\x06"
"\x0f\x00\x00\x00\x89\x46\x0c\x80\x3c\x38\x3d\x0f\x85\x8b\x00\x00"
"\x00\x40\x5f\xc7\x06\x11\x00\x00\x00\x89\x46\x0c\x5b\x8b\x8c\x24"
"\x00\x01\x00\x00\xe8\xff\x2a\x00\x00\x81\xc4\x04\x01\x00\x00\xc3"
"\x40\x5f\xc7\x06\x0b\x00\x00\x00\x89\x46\x0c\x5b\x8b\x8c\x24\x00"
"\x01\x00\x00\xe8\xe0\x2a\x00\x00\x81\xc4\x04\x01\x00\x00\xc3\x55"
"\x8d\x68\x01\x89\x6e\x0c\xc7\x06\x08\x00\x00\x00\x89\x5e\x04\x8a"
"\x04\x2f\xe8\x29\xfc\xff\xff\x85\xc0\x74\x30\xeb\x03\x8d\x49\x00"
"\x8b\x5e\x04\xc1\xe3\x04\x89\x5e\x04\x8a\x0c\x2f\xe8\x7f\xfc\xff"
"\xff\x03\xc3\x45\x89\x46\x04\x89\x6e\x0c\x8b\x46\x08\x8b\xcd\x8a"
"\x04\x08\xe8\xf9\xfb\xff\xff\x85\xc0\x75\xd5\x5d\x5f\x5b\x8b\x8c"
"\x24\x00\x01\x00\x00\xe8\x7e\x2a\x00\x00\x81\xc4\x04\x01\x00\x00"
"\xc3\xc7\x06\x08\x00\x00\x00\x89\x5e\x04\x8d\x9b\x00\x00\x00\x00"
"\x8b\x4e\x0c\x8a\x04\x0f\x3c\x30\x7c\xd2\x3c\x39\x7f\xce\x8b\x46"
"\x04\x8d\x04\x80\xd1\xe0\x89\x46\x04\x0f\xbe\x14\x0f\x8d\x44\x02"
"\xd0\x41\x89\x46\x04\x89\x4e\x0c\xeb\xd6\x51\x33\xff\xe8\x0e\x81"
"\xff\xff\x83\xc4\x04\x85\xc0\x74\x30\x8d\xa4\x24\x00\x00\x00\x00"
"\x8b\x46\x0c\x8b\x4e\x08\x8a\x14\x08\x40\x89\x46\x0c\x88\x54\x3c"
"\x08\x8b\xc1\x8b\x4e\x0c\x33\xd2\x8a\x14\x08\x47\x52\xe8\xde\x80"
"\xff\xff\x83\xc4\x04\x85\xc0\x75\xd7\x8d\x46\x04\x50\x89\x18\x8d"
"\x44\x24\x0c\x53\x50\x88\x5c\x3c\x14\xc7\x06\x08\x00\x00\x00\xff"
"\x56\x10\x8b\x8c\x24\x14\x01\x00\x00\x83\xc4\x0c\x5f\x5b\xe8\xd5"
"\x29\x00\x00\x81\xc4\x04\x01\x00\x00\xc3\x8b\xff\x6d\x40\x66\x00"
"\xbf\x40\x66\x00\xf8\x3e\x66\x00\x88\x3f\x66\x00\x17\x3f\x66\x00"
"\x36\x3f\x66\x00\xba\x3e\x66\x00\x80\x3e\x66\x00\x9b\x3e\x66\x00"
"\xd9\x3e\x66\x00\x21\x41\x66\x00\x65\x3e\x66\x00\x1b\x40\x66\x00"
"\xbb\x3f\x66\x00\xe8\x3f\x66\x00\x5a\x41\x66\x00\x4e\x40\x66\x00"
"\x55\x3f\x66\x00\xa0\x40\x66\x00\x0c\x41\x66\x00\x00\x13\x13\x01"
"\x02\x03\x13\x04\x05\x06\x07\x13\x08\x13\x09\x0a\x0a\x0a\x0a\x0a"
"\x0a\x0a\x0a\x0a\x0a\x13\x0b\x0c\x0d\x0e\x13\x13\x0f\x0f\x0f\x0f"
"\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f"
"\x0f\x0f\x0f\x0f\x0f\x0f\x13\x13\x13\x10\x13\x13\x0f\x0f\x0f\x0f"
"\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f"
"\x0f\x0f\x0f\x0f\x0f\x0f\x13\x11\x13\x12\xcc\xcc\xcc\xcc\xcc\xcc"
"\x56\x8b\x74\x24\x08\x8b\x06\x48\x83\xf8\x0e\x77\x73\x0f\xb6\x80"
"\x20\x43\x66\x00\xff\x24\x85\x04\x43\x66\x00\xe8\x40\xfb\xff\xff"
"\x8b\x46\x04\x5e\xc3\xe8\x36\xfb\xff\xff\x56\xe8\xd0\xff\xff\xff"
"\x83\xc4\x04\xf7\xd8\x5e\xc3\xe8\x24\xfb\xff\xff\x56\xe8\xbe\xff"
"\xff\xff\x83\xc4\x04\xf7\xd0\x5e\xc3\xe8\x12\xfb\xff\xff\x56\xe8"
"\xac\xff\xff\xff\x83\xc4\x04\xf7\xd8\x1b\xc0\x40\x5e\xc3\x57\xe8"
"\xfc\xfa\xff\xff\x56\xe8\xa6\x01\x00\x00\x83\xc4\x04\x8b\xf8\xe8"
"\xec\xfa\xff\xff\x8b\xc7\x5f\x5e\xc3\xb8\x01\x00\x00\x00\x5e\xc3"
"\x33\xc0\x5e\xc3\xa5\x42\x66\x00\xde\x42\x66\x00\xf9\x42\x66\x00"
"\x9b\x42\x66\x00\xb7\x42\x66\x00\xc9\x42\x66\x00\x00\x43\x66\x00"
"\x00\x06\x06\x06\x01\x06\x02\x03\x06\x06\x04\x06\x06\x06\x05\xcc"
"\x56\x8b\xf0\x57\x56\xe8\x46\xff\xff\xff\x8b\xf8\x8b\x06\x83\xe8"
"\x02\x83\xc4\x04\x83\xf8\x13\x0f\x87\xfd\x00\x00\x00\x8d\x49\x00"
"\x0f\xb6\x80\x78\x44\x66\x00\xff\x24\x85\x50\x44\x66\x00\xe8\x7d"
"\xfa\xff\xff\x56\xe8\x17\xff\xff\xff\x83\xc4\x04\x0f\xaf\xf8\xe9"
"\xc8\x00\x00\x00\xe8\x67\xfa\xff\xff\x56\xe8\x01\xff\xff\xff\x8b"
"\xc8\x8b\xc7\x99\x83\xc4\x04\xf7\xf9\x8b\xf8\xe9\xac\x00\x00\x00"
"\xe8\x4b\xfa\xff\xff\x56\xe8\xe5\xfe\xff\xff\x8b\xc8\x8b\xc7\x99"
"\x83\xc4\x04\xf7\xf9\x8b\xfa\xe9\x90\x00\x00\x00\xe8\x2f\xfa\xff"
"\xff\x56\xe8\xc9\xfe\xff\xff\x33\xd2\x83\xc4\x04\x3b\xf8\x0f\x94"
"\xc2\x8b\xfa\xeb\x77\xe8\x16\xfa\xff\xff\x56\xe8\xb0\xfe\xff\xff"
"\x33\xc9\x83\xc4\x04\x3b\xf8\x0f\x95\xc1\xeb\x5e\xe8\xff\xf9\xff"
"\xff\x56\xe8\x99\xfe\xff\xff\x33\xd2\x83\xc4\x04\x3b\xf8\x0f\x9c"
"\xc2\x8b\xfa\xeb\x47\xe8\xe6\xf9\xff\xff\x56\xe8\x80\xfe\xff\xff"
"\x33\xc9\x83\xc4\x04\x3b\xf8\x0f\x9f\xc1\xeb\x2e\xe8\xcf\xf9\xff"
"\xff\x56\xe8\x69\xfe\xff\xff\x33\xd2\x83\xc4\x04\x3b\xf8\x0f\x9e"
"\xc2\x8b\xfa\xeb\x17\xe8\xb6\xf9\xff\xff\x56\xe8\x50\xfe\xff\xff"
"\x33\xc9\x83\xc4\x04\x3b\xf8\x0f\x9d\xc1\x8b\xf9\x8b\x06\x83\xe8"
"\x02\x83\xf8\x13\x0f\x86\x06\xff\xff\xff\x8b\xc7\x5f\x5e\xc3\x90"
"\x5e\x43\x66\x00\x74\x43\x66\x00\x90\x43\x66\x00\xac\x43\x66\x00"
"\xc5\x43\x66\x00\xdc\x43\x66\x00\xf5\x43\x66\x00\x0c\x44\x66\x00"
"\x25\x44\x66\x00\x4a\x44\x66\x00\x00\x01\x02\x09\x09\x09\x09\x09"
"\x09\x09\x09\x09\x09\x09\x03\x04\x05\x06\x07\x08\xcc\xcc\xcc\xcc"
"\x56\x8b\x74\x24\x08\x57\x8b\xc6\xe8\x93\xfe\xff\xff\x8b\xf8\x8b"
"\x06\x83\xf8\x0e\x0f\x87\xa0\x00\x00\x00\x8d\x9b\x00\x00\x00\x00"
"\x0f\xb6\x80\x70\x45\x66\x00\xff\x24\x85\x50\x45\x66\x00\xe8\x1d"
"\xf9\xff\xff\x8b\xc6\xe8\x66\xfe\xff\xff\x03\xf8\xeb\x71\xe8\x0d"
"\xf9\xff\xff\x8b\xc6\xe8\x56\xfe\xff\xff\x2b\xf8\xeb\x61\xe8\xfd"
"\xf8\xff\xff\x8b\xc6\xe8\x46\xfe\xff\xff\x23\xf8\xeb\x51\xe8\xed"
"\xf8\xff\xff\x8b\xc6\xe8\x36\xfe\xff\xff\x0b\xf8\xeb\x41\xe8\xdd"
"\xf8\xff\xff\x8b\xc6\xe8\x26\xfe\xff\xff\x33\xf8\xeb\x31\xe8\xcd"
"\xf8\xff\xff\x8b\xc6\xe8\x16\xfe\xff\xff\x85\xff\x74\x04\x85\xc0"
"\x75\x18\x33\xff\xeb\x19\xe8\xb5\xf8\xff\xff\x8b\xc6\xe8\xfe\xfd"
"\xff\xff\x85\xff\x75\x04\x85\xc0\x74\x05\xbf\x01\x00\x00\x00\x8b"
"\x06\x83\xf8\x0e\x0f\x86\x66\xff\xff\xff\x8b\xc7\x5f\x5e\xc3\x90"
"\xbe\x44\x66\x00\xce\x44\x66\x00\xee\x44\x66\x00\xde\x44\x66\x00"
"\xfe\x44\x66\x00\x26\x45\x66\x00\x0e\x45\x66\x00\x4a\x45\x66\x00"
"\x00\x01\x07\x07\x07\x07\x07\x07\x07\x02\x03\x07\x04\x05\x06\xcc"
"\x83\xec\x14\x8b\x44\x24\x18\x89\x44\x24\x08\x33\xc0\x56\x8d\x74"
"\x24\x04\x89\x44\x24\x10\x89\x44\x24\x14\xe8\x41\xf8\xff\xff\x8b"
"\xce\x51\xe8\xe9\xfe\xff\xff\x83\xc4\x04\x5e\x83\xc4\x14\xc3\xcc"
"\xff\x0d\x24\x5d\x6f\x00\x78\x10\xa1\x20\x5d\x6f\x00\xc6\x00\x0a"
"\xff\x05\x20\x5d\x6f\x00\xeb\x0f\x68\x20\x5d\x6f\x00\x6a\x0a\xe8"
"\x17\x5e\x00\x00\x83\xc4\x08\x8b\x54\x24\x04\x8d\x4c\x24\x08\x51"
"\x52\x68\x20\x5d\x6f\x00\xe8\xcf\x5d\x00\x00\xa1\x24\x5d\x6f\x00"
"\x83\xc4\x0c\x48\xa3\x24\x5d\x6f\x00\x78\x10\xa1\x20\x5d\x6f\x00"
"\xc6\x00\x0a\xff\x05\x20\x5d\x6f\x00\xeb\x0f\x68\x20\x5d\x6f\x00"
"\x6a\x0a\xe8\xd4\x5d\x00\x00\x83\xc4\x08\x6a\x01\xe8\xd7\x30\x00"
"\x00\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc"
"\x8b\x44\x24\x04\x0f\xb6\x50\x01\x33\xc9\x8a\x68\x03\x8a\x48\x02"
"\x0f\xb6\x00\xc1\xe1\x08\x0b\xca\x8b\x54\x24\x08\xc1\xe1\x08\x0b"
"\xc8\x8b\x04\x95\xd4\x5b\x6f\x00\x23\xc1\xc3\xcc\xcc\xcc\xcc\xcc"
"\x8b\x4c\x24\x04\x8b\x15\xe0\xe6\xc4\x02\xa1\xec\x1d\xc2\x02\xd3"
"\xe2\x89\x15\xe0\xe6\xc4\x02\x8b\x15\xf0\x1d\xc2\x02\x3b\xca\x76"
"\x4c\x56\x8b\x35\xe4\xe6\xc4\x02\x57\x8b\x3d\xd8\xe6\xc4\x02\x90"
"\x2b\xca\x8b\x15\xe0\xe6\xc4\x02\xd3\xe0\x0b\xd0\x85\xf6\x89\x15"
"\xe0\xe6\xc4\x02\x74\x15\x4e\x89\x35\xe4\xe6\xc4\x02\x8a\x07\x47"
"\x89\x3d\xd8\xe6\xc4\x02\x0f\xb6\xc0\xeb\x02\x33\xc0\xba\x08\x00"
"\x00\x00\x3b\xca\x77\xca\x5f\xa3\xec\x1d\xc2\x02\x5e\x2b\xd1\x8b"
"\xca\xd3\xe8\x8b\x0d\xe0\xe6\xc4\x02\x89\x15\xf0\x1d\xc2\x02\x0b"
"\xc8\x89\x0d\xe0\xe6\xc4\x02\xc3\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc"
"\x8b\x44\x24\x04\x85\xc0\x75\x01\xc3\x56\x8b\x35\xe0\xe6\xc4\x02"
"\xb9\x20\x00\x00\x00\x2b\xc8\x50\xd3\xee\xe8\x51\xff\xff\xff\x83"
"\xc4\x04\x8b\xc6\x5e\xc3\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc"
"\x33\xc0\x6a\x20\xa3\xe0\xe6\xc4\x02\xa3\xec\x1d\xc2\x02\xa3\xf0"
"\x1d\xc2\x02\xe8\x28\xff\xff\xff\x59\xc3\xcc\xcc\xcc\xcc\xcc\xcc"
"\x55\x56\x8b\xf0\x57\x56\xe8\xa5\xff\xff\xff\x8b\xe8\x83\xc4\x04"
"\x85\xed\x75\x45\x56\xe8\x96\xff\xff\xff\x8b\x4c\x24\x14\x83\xc4"
"\x04\x85\xc9\x8b\xd0\x7e\x15\x8b\xf1\xc1\xe9\x02\x33\xc0\xbf\xfc"
"\x41\xc2\x02\xf3\xab\x8b\xce\x83\xe1\x03\xf3\xaa\x8b\xc2\x66\x8b"
"\xd0\xb9\x80\x00\x00\x00\xbf\xf8\x1d\xc2\x02\xc1\xe2\x10\x66\x8b"
"\xd0\x8b\xc2\xf3\xab\x5f\x5e\x5d\xc3\x33\xf6\x85\xed\x7e\x7c\x53"
"\x8b\x0d\xe0\xe6\xc4\x02\x8b\xd9\xc1\xeb\x1d\x83\xfb\x07\x75\x1a"
"\xb8\x00\x00\x00\x10\x85\xc8\x74\x0e\x8d\xa4\x24\x00\x00\x00\x00"
"\xd1\xe8\x43\x85\xc8\x75\xf9\x83\xfb\x07\xb8\x03\x00\x00\x00\x7c"
"\x03\x8d\x43\xfd\x50\xe8\x86\xfe\xff\xff\x8b\x44\x24\x1c\x83\xc4"
"\x04\x88\x9e\xfc\x41\xc2\x02\x46\x3b\xf0\x75\x2a\x6a\x02\xe8\xfd"
"\xfe\xff\xff\x83\xc4\x04\x48\x78\x1d\x8d\x50\x01\x8b\xca\x8b\xd9"
"\xc1\xe9\x02\x8d\xbe\xfc\x41\xc2\x02\x33\xc0\xf3\xab\x8b\xcb\x83"
"\xe1\x03\xf3\xaa\x03\xf2\x3b\xf5\x7c\x86\x5b\x8b\x54\x24\x10\x3b"
"\xf2\x7d\x1a\x8b\xca\x2b\xce\x8d\xbe\xfc\x41\xc2\x02\x8b\xf1\xc1"
"\xe9\x02\x33\xc0\xf3\xab\x8b\xce\x83\xe1\x03\xf3\xaa\x68\xf8\x1d"
"\xc2\x02\x6a\x08\x68\xfc\x41\xc2\x02\x52\xe8\x91\x02\x00\x00\x83"
"\xc4\x10\x5f\x5e\x5d\xc3\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc"
"\x55\x57\x6a\x09\xe8\x87\xfe\xff\xff\x8b\xe8\x83\xc4\x04\x85\xed"
"\x75\x38\x6a\x09\xe8\x77\xfe\xff\xff\x8b\xd0\x33\xc0\xb9\x7f\x00"
"\x00\x00\xbf\xf8\x1f\xc2\x02\xf3\xab\x66\xab\x8b\xc2\x66\x8b\xd0"
"\x83\xc4\x04\xb9\x00\x08\x00\x00\xbf\xf8\x21\xc2\x02\xc1\xe2\x10"
"\x66\x8b\xd0\x8b\xc2\xf3\xab\x5f\x5d\xc3\x56\x33\xf6\x85\xed\x0f"
"\x8e\xc6\x00\x00\x00\x53\xeb\x08\x8d\xa4\x24\x00\x00\x00\x00\x90"
"\x0f\xb6\x05\xe3\xe6\xc4\x02\x0f\xb7\x1c\x45\xf8\x1d\xc2\x02\x83"
"\xfb\x13\x7c\x29\x8b\x0d\xe0\xe6\xc4\x02\xb8\x00\x00\x80\x00\x90"
"\x85\xc8\x74\x0a\x0f\xb7\x1c\x5d\xe0\xde\xc4\x02\xeb\x08\x0f\xb7"
"\x1c\x5d\xe0\xd6\xc4\x02\xd1\xe8\x83\xfb\x13\x7d\xe3\x0f\xb6\x8b"
"\xfc\x41\xc2\x02\x51\xe8\x56\xfd\xff\xff\x83\xc4\x04\x83\xfb\x02"
"\x7f\x4e\x85\xdb\x75\x07\xb8\x01\x00\x00\x00\xeb\x21\x83\xfb\x01"
"\x75\x0f\x6a\x04\xe8\xc7\xfd\xff\xff\x83\xc4\x04\x83\xc0\x03\xeb"
"\x0d\x6a\x09\xe8\xb8\xfd\xff\xff\x83\xc4\x04\x83\xc0\x14\x48\x78"
"\x29\x8d\x50\x01\x8b\xca\x8b\xd9\xc1\xe9\x02\x8d\xbe\xf8\x1f\xc2"
"\x02\x33\xc0\xf3\xab\x8b\xcb\x83\xe1\x03\xf3\xaa\x03\xf2\xeb\x0a"
"\x80\xeb\x02\x88\x9e\xf8\x1f\xc2\x02\x46\x3b\xf5\x0f\x8c\x4e\xff"
"\xff\xff\x81\xfe\xfe\x01\x00\x00\x5b\x7d\x1d\xb9\xfe\x01\x00\x00"
"\x2b\xce\x8b\xd1\xc1\xe9\x02\x33\xc0\x8d\xbe\xf8\x1f\xc2\x02\xf3"
"\xab\x8b\xca\x83\xe1\x03\xf3\xaa\x68\xf8\x21\xc2\x02\x6a\x0c\x68"
"\xf8\x1f\xc2\x02\x68\xfe\x01\x00\x00\xe8\x32\x01\x00\x00\x83\xc4"
"\x10\x5e\x5f\x5d\xc3\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc"
"\xa1\xf8\x41\xc2\x02\x85\xc0\x75\x30\x6a\x10\xe8\x20\xfd\xff\xff"
"\xa3\xf8\x41\xc2\x02\x6a\x03\x6a\x13\xb8\x05\x00\x00\x00\xe8\x5d"
"\xfd\xff\xff\xe8\x78\xfe\xff\xff\x6a\xff\x6a\x0e\xb8\x04\x00\x00"
"\x00\xe8\x4a\xfd\xff\xff\x83\xc4\x14\x8b\x0d\xe0\xe6\xc4\x02\x56"
"\x8b\x35\xf8\x41\xc2\x02\x4e\x8b\xc1\xc1\xe8\x14\x89\x35\xf8\x41"
"\xc2\x02\x0f\xb7\x34\x45\xf8\x21\xc2\x02\x81\xfe\xfe\x01\x00\x00"
"\x72\x25\xb8\x00\x00\x08\x00\x85\xc8\x74\x0a\x0f\xb7\x34\x75\xe0"
"\xde\xc4\x02\xeb\x08\x0f\xb7\x34\x75\xe0\xd6\xc4\x02\xd1\xe8\x81"
"\xfe\xfe\x01\x00\x00\x73\xe0\x0f\xb6\x8e\xf8\x1f\xc2\x02\x51\xe8"
"\x0c\xfc\xff\xff\x83\xc4\x04\x8b\xc6\x5e\xc3\xcc\xcc\xcc\xcc\xcc"
"\x0f\xb6\x05\xe3\xe6\xc4\x02\x56\x0f\xb7\x34\x45\xf8\x1d\xc2\x02"
"\x83\xfe\x0e\x72\x28\x8b\x0d\xe0\xe6\xc4\x02\xb8\x00\x00\x80\x00"
"\x85\xc8\x74\x0a\x0f\xb7\x34\x75\xe0\xde\xc4\x02\xeb\x08\x0f\xb7"
"\x34\x75\xe0\xd6\xc4\x02\xd1\xe8\x83\xfe\x0e\x73\xe3\x0f\xb6\x8e"
"\xfc\x41\xc2\x02\x51\xe8\xb6\xfb\xff\xff\x83\xc4\x04\x85\xf6\x74"
"\x1a\x8d\x56\xff\x52\xe8\x36\xfc\xff\xff\x8d\x4e\xff\xba\x01\x00"
"\x00\x00\xd3\xe2\x83\xc4\x04\x5e\x03\xc2\xc3\x8b\xc6\x5e\xc3\xcc"
"\xe8\x4b\xfc\xff\xff\xc7\x05\xf8\x41\xc2\x02\x00\x00\x00\x00\xc3"
"\x83\xec\x58\xa1\x40\x5c\x6f\x00\x89\x44\x24\x54\x33\xc0\x89\x44"
"\x24\x0e\x89\x44\x24\x12\x89\x44\x24\x16\x89\x44\x24\x1a\x53\x89"
"\x44\x24\x22\x55\x8b\x6c\x24\x64\x85\xed\x89\x44\x24\x2a\x56\x89"
"\x44\x24\x32\x57\x89\x44\x24\x3a\x76\x1c\x8d\x9b\x00\x00\x00\x00"
"\x8b\x4c\x24\x70\x0f\xb6\x0c\x08\x66\xff\x44\x4c\x1c\x8d\x4c\x4c"
"\x1c\x40\x3b\xc5\x72\xea\x66\xc7\x44\x24\x42\x00\x00\xbe\x0e\x00"
"\x00\x00\xb8\x02\x00\x00\x00\x33\xff\x66\x8b\x7c\x04\x1e\x33\xd2"
"\x66\x8b\x54\x04\x1c\x8d\x4e\x01\x66\xd3\xe2\x8b\xce\x66\xd3\xe7"
"\x8d\x4e\xff\x66\x03\x54\x04\x40\x83\xc0\x08\x66\x89\x54\x04\x3a"
"\x03\xd7\x33\xff\x66\x8b\x7c\x04\x18\x66\xd3\xe7\x66\x89\x54\x04"
"\x3c\x8d\x4e\xfe\x83\xee\x04\x03\xd7\x33\xff\x66\x8b\x7c\x04\x1a"
"\x66\xd3\xe7\x66\x89\x54\x04\x3e\x03\xfa\x83\xf8\x20\x66\x89\x7c"
"\x04\x40\x76\xa3\x66\x83\x7c\x24\x62\x00\x74\x0d\x68\xb0\xc3\x6a"
"\x00\xe8\xfa\xf9\xff\xff\x83\xc4\x04\x8b\x74\x24\x74\xbb\x10\x00"
"\x00\x00\x2b\xde\xb8\x01\x00\x00\x00\x3b\xf0\x89\x5c\x24\x14\x72"
"\x24\x8d\x56\xff\x66\x8b\xcb\x66\xd3\x6c\x44\x40\x8b\xca\xbf\x01"
"\x00\x00\x00\xd3\xe7\x40\x4a\x3b\xc6\x66\x89\x7c\x44\x1a\x76\xe4"
"\x83\xf8\x10\x77\x1e\xb9\x10\x00\x00\x00\x2b\xc8\x8d\x64\x24\x00"
"\xba\x01\x00\x00\x00\xd3\xe2\x40\x49\x83\xf8\x10\x66\x89\x54\x44"
"\x1a\x76\xed\x0f\xb7\x44\x74\x42\x8a\xcb\xd3\xe8\x85\xc0\x74\x23"
"\xba\x01\x00\x00\x00\x8b\xce\xd3\xe2\x3b\xc2\x74\x16\x8b\x4c\x24"
"\x78\x8d\x3c\x41\x8b\xca\x2b\xc8\x33\xc0\xd1\xe9\xf3\xab\x13\xc9"
"\x66\xf3\xab\xb9\x0f\x00\x00\x00\x2b\xce\xb8\x01\x00\x00\x00\xd3"
"\xe0\x33\xc9\x85\xed\x8b\xdd\x89\x44\x24\x18\x89\x4c\x24\x74\x0f"
"\x86\xc8\x00\x00\x00\x8b\x54\x24\x70\x0f\xb6\x04\x11\x85\xc0\x0f"
"\x84\xab\x00\x00\x00\x0f\xb7\x54\x44\x40\x0f\xb7\x6c\x44\x1c\x8d"
"\x4c\x44\x40\x03\xea\x3b\xc6\x89\x4c\x24\x10\x77\x2d\x3b\xd5\x0f"
"\x83\x7c\x00\x00\x00\x8b\x44\x24\x78\x8d\x3c\x50\x8b\x44\x24\x74"
"\x8b\xcd\x2b\xca\x66\x8b\xd0\xc1\xe2\x10\x66\x8b\xd0\xd1\xe9\x8b"
"\xc2\xf3\xab\x13\xc9\x66\xf3\xab\xeb\x57\x8b\x4c\x24\x14\x8b\xfa"
"\xd3\xef\x2b\xc6\x8b\x4c\x24\x78\x8d\x0c\x79\x74\x3c\x8d\x49\x00"
"\x33\xff\x66\x39\x39\x75\x14\x66\x89\x3c\x5d\xe0\xd6\xc4\x02\x66"
"\x89\x3c\x5d\xe0\xde\xc4\x02\x66\x89\x19\x43\x85\x54\x24\x18\x0f"
"\xb7\x09\x74\x09\x8d\x0c\x4d\xe0\xde\xc4\x02\xeb\x07\x8d\x0c\x4d"
"\xe0\xd6\xc4\x02\xd1\xe2\x48\x75\xc7\x66\x8b\x54\x24\x74\x66\x89"
"\x11\x8b\x44\x24\x10\x8b\x4c\x24\x74\x66\x89\x28\x8b\x6c\x24\x6c"
"\x41\x3b\xcd\x89\x4c\x24\x74\x0f\x82\x38\xff\xff\xff\x8b\x4c\x24"
"\x64\x5f\x5e\x5d\x5b\xe8\x5e\x1e\x00\x00\x83\xc4\x58\xc3";

int __cdecl (*unlz2k)(unsigned char *in, unsigned char *out, int insz, int outsz) = NULL;



// anti DEP limitation! if you apply VirtualAlloc on a static char
// it will cover also the rest of the page included other variables!
void *unlz2k_alloc(u8 *dump, int dumpsz) {
    int     pagesz;
    void    *ret;

    pagesz = (dumpsz + 4095) & (~4095); // useful for pages? mah

#ifdef WIN32
    ret = VirtualAlloc(
        NULL,
        pagesz,
        MEM_COMMIT | MEM_RESERVE,
        PAGE_EXECUTE_READWRITE);    // write for memcpy
#else
    ret = malloc(pagesz);
    mprotect(
        ret,
        pagesz,
        PROT_EXEC | PROT_WRITE);    // write for memcpy
#endif
    memcpy(ret, dump, dumpsz);
    return(ret);
}



void unlz2k_init(void) {
    if(unlz2k) return;
    unsigned    newoff;
    unsigned char   *func;

    func = (unsigned char *)unlz2k_alloc(unlz2k_dump, sizeof(unlz2k_dump));

    x006f5bd0 = calloc(0x200, 1);
    x02c1fde0 = calloc(0x30000, 1);

    #define PATCHIT(X,Y) \
        newoff = (int)(Y); \
        memcpy(func + X, (void *)&newoff, 4);

    PATCHIT(0x00000003, x02c1fde0 + 0x00000000)
    PATCHIT(0x0000000d, x02c1fde0 + 0x00000000)
    PATCHIT(0x00000014, x02c1fde0 + 0x00002008)
    PATCHIT(0x00000036, x02c1fde0 + 0x00000000)
    PATCHIT(0x0000003b, x02c1fde0 + 0x00002008)
    PATCHIT(0x0000005d, x02c1fde0 + 0x00000000)
    PATCHIT(0x00000068, x02c1fde0 + 0x00000000)
    PATCHIT(0x0000007a, x02c1fde0 + 0x00002008)
    PATCHIT(0x00000080, x02c1fde0 + 0x00000000)
    PATCHIT(0x00000096, x02c1fde0 + 0x00002008)
    PATCHIT(0x0000009e, x02c1fde0 + 0x00000000)
    PATCHIT(0x000000a8, x02c1fde0 + 0x00000000)
    PATCHIT(0x000000ad, x02c1fde0 + 0x00002008)
    PATCHIT(0x000000dd, x02c1fde0 + 0x0002e8f8)
    PATCHIT(0x000000e7, x02c1fde0 + 0x0002e8fc)
    PATCHIT(0x000000ed, x02c1fde0 + 0x0002e908)
    PATCHIT(0x000000f2, x02c1fde0 + 0x0002e904)
    PATCHIT(0x000000fc, x02c1fde0 + 0x0002e908)
    PATCHIT(0x00000104, x02c1fde0 + 0x00000000)
    PATCHIT(0x0000012c, x02c1fde0 + 0x0002e8fc)
    PATCHIT(0x00000141, x02c1fde0 + 0x0002e908)
    PATCHIT(0x00000147, x02c1fde0 + 0x0002e8fc)
    PATCHIT(0x00000155, x02c1fde0 + 0x0002e8fc)
    PATCHIT(0x0000015a, x02c1fde0 + 0x0002e908)
    PATCHIT(0x00000ad6, x02c1fde0 + 0x0002e900)
    PATCHIT(0x00000adb, x02c1fde0 + 0x0000200c)
    PATCHIT(0x00000ae3, x02c1fde0 + 0x0002e900)
    PATCHIT(0x00000ae9, x02c1fde0 + 0x00002010)
    PATCHIT(0x00000af4, x02c1fde0 + 0x0002e904)
    PATCHIT(0x00000afb, x02c1fde0 + 0x0002e8f8)
    PATCHIT(0x00000b04, x02c1fde0 + 0x0002e900)
    PATCHIT(0x00000b10, x02c1fde0 + 0x0002e900)
    PATCHIT(0x00000b19, x02c1fde0 + 0x0002e904)
    PATCHIT(0x00000b22, x02c1fde0 + 0x0002e8f8)
    PATCHIT(0x00000b38, x02c1fde0 + 0x0000200c)
    PATCHIT(0x00000b45, x02c1fde0 + 0x0002e900)
    PATCHIT(0x00000b4b, x02c1fde0 + 0x00002010)
    PATCHIT(0x00000b53, x02c1fde0 + 0x0002e900)
    PATCHIT(0x00000b6c, x02c1fde0 + 0x0002e900)
    PATCHIT(0x00000b95, x02c1fde0 + 0x0002e900)
    PATCHIT(0x00000b9a, x02c1fde0 + 0x0000200c)
    PATCHIT(0x00000b9f, x02c1fde0 + 0x00002010)
    PATCHIT(0x00000c12, x02c1fde0 + 0x0002e900)
    PATCHIT(0x00000d33, x02c1fde0 + 0x0002e903)
    PATCHIT(0x00000d46, x02c1fde0 + 0x0002e900)
    PATCHIT(0x00000e31, x02c1fde0 + 0x00004418)
    PATCHIT(0x00000e41, x02c1fde0 + 0x00004418)
    PATCHIT(0x00000e6b, x02c1fde0 + 0x0002e900)
    PATCHIT(0x00000e72, x02c1fde0 + 0x00004418)
    PATCHIT(0x00000e7e, x02c1fde0 + 0x00004418)
    PATCHIT(0x00000ed3, x02c1fde0 + 0x0002e903)
    PATCHIT(0x00000ee7, x02c1fde0 + 0x0002e900)
    PATCHIT(0x00000f47, x02c1fde0 + 0x00004418)

    PATCHIT(0x00000c53, x02c1fde0 + 0x0000441c)
    PATCHIT(0x00000c75, x02c1fde0 + 0x0000441c)
    PATCHIT(0x00000c99, x02c1fde0 + 0x0000441c)
    PATCHIT(0x00000d3b, x02c1fde0 + 0x00002018)
    PATCHIT(0x00000d58, x02c1fde0 + 0x0002e100)
    PATCHIT(0x00000d62, x02c1fde0 + 0x0002d900)
    PATCHIT(0x00000d70, x02c1fde0 + 0x0000441c)
    PATCHIT(0x00000dbd, x02c1fde0 + 0x00002218)
    PATCHIT(0x00000dd5, x02c1fde0 + 0x00002218)
    PATCHIT(0x00000dfb, x02c1fde0 + 0x00002218)
    PATCHIT(0x00000e86, x02c1fde0 + 0x00002418)
    PATCHIT(0x00000e9f, x02c1fde0 + 0x0002e100)
    PATCHIT(0x00000ea9, x02c1fde0 + 0x0002d900)
    PATCHIT(0x00000eba, x02c1fde0 + 0x00002218)
    PATCHIT(0x00000edc, x02c1fde0 + 0x00002018)
    PATCHIT(0x00000ef8, x02c1fde0 + 0x0002e100)
    PATCHIT(0x00000f02, x02c1fde0 + 0x0002d900)
    PATCHIT(0x00000f10, x02c1fde0 + 0x0000441c)
    PATCHIT(0x0000114b, x02c1fde0 + 0x0002d900)
    PATCHIT(0x00001153, x02c1fde0 + 0x0002e100)
    PATCHIT(0x00001167, x02c1fde0 + 0x0002e100)
    PATCHIT(0x00001170, x02c1fde0 + 0x0002d900)

    PATCHIT(0x0000011f, x02c1fde0 + 0x00000008)
    PATCHIT(0x00000bdf, x02c1fde0 + 0x0000441c)
    PATCHIT(0x00000bf7, x02c1fde0 + 0x00002018)
    PATCHIT(0x00000cae, x02c1fde0 + 0x00002018)
    PATCHIT(0x00000cb5, x02c1fde0 + 0x0000441c)
    PATCHIT(0x00000cf3, x02c1fde0 + 0x00002218)
    PATCHIT(0x00000d09, x02c1fde0 + 0x00002418)
    PATCHIT(0x00000e09, x02c1fde0 + 0x00002418)
    PATCHIT(0x00000e10, x02c1fde0 + 0x00002218)

    PATCHIT(0x000000c1, x006f5bd0 + 0x00000000)
    PATCHIT(0x00000257, x006f5bd0 + 0x00000070)
    PATCHIT(0x00000a22, x006f5bd0 + 0x00000154)
    PATCHIT(0x00000a29, x006f5bd0 + 0x00000150)
    PATCHIT(0x00000a32, x006f5bd0 + 0x00000150)
    PATCHIT(0x00000a5c, x006f5bd0 + 0x00000154)
    PATCHIT(0x00000a65, x006f5bd0 + 0x00000154)
    PATCHIT(0x00000a6c, x006f5bd0 + 0x00000150)
    PATCHIT(0x00000a75, x006f5bd0 + 0x00000150)
    PATCHIT(0x00000f54, x006f5bd0 + 0x00000070)

    #undef PATCHIT

    memset(func + 0x11a5, 0x90, 5);
    memset(x006f5bd0, 0xff, 4); // *(unsigned *)x006f5bd0 != 0;

    unlz2k = (void *)(func + 0xc0);
}


