// modified by Luigi Auriemma
#include <stdlib.h>
#include <string.h>
#define NOASM
static
unsigned char   *infile  = 0,
                *infilel = 0;
static int xgetc(void *skip) {
    if(infile >= infilel) return(-1);
    return(*infile++);
}
#define archive infile

/* PAQ6v2 - File archiver and compressor.
(C) 2004, Matt Mahoney, mmahoney@cs.fit.edu

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License version 2 as
published by the Free Software Foundation at
http://www.gnu.org/licenses/gpl.txt or (at your option) any later version.
This program is distributed without any warranty.

...
*/

//#define PROGNAME "PAQ6"  // Please change this if you change the program

#define hash ___hash  // To avoid Digital MARS name collision
#include <cstdio>
#include <cstdlib>
#include <cctype>
#include <cmath>
#include <ctime>
#include <cassert>
#include <new>
#include <string>
#include <vector>
#include <algorithm>
#include <map>
#undef hash
using namespace std;

const int PSCALE=4096;  // Integer scale for representing probabilities
int MEM=3;        // Use about 6 MB * 2^MEM bytes of memory                      

template <class T> inline int size(const T& t) {return t.size();}

// 8-32 bit unsigned types, adjust as appropriate
typedef unsigned char U8;
typedef unsigned short U16;
typedef unsigned long U32;

//////////////////////////// rnd ////////////////////////////

// 32-bit random number generator based on r(i) = r(i-24) ^ r(i-55)

class Random {
  U32 table[55];  // Last 55 random values
  int i;  // Index of current random value in table
public:
  Random();
  U32 operator()() {  // Return 32-bit random number
    if (++i==55) i=0;
    if (i>=24) return table[i]^=table[i-24];
    else return table[i]^=table[i+31];
  }
} rnd;

Random::Random(): i(0) {  // Seed the table
  table[0]=123456789;
  table[1]=987654321;
  for (int j=2; j<55; ++j)
    table[j]=table[j-1]*11+table[j-2]*19/16;					
}

//////////////////////////// hash ////////////////////////////

// Hash functoid, returns 32 bit hash of 1-4 chars

class Hash {
  U32 table[8][256]=  // Random number table
{ // pre-built
{ 0x6a4b231b,0xea70b611,0x691a2c2c,0xf3c37eea,0x8c865aa6,0xd3f4afc7,0xb0a54478,0xa4cf7e5c,0xd78c60f0,0xd0059c4f,0x8fb4933c,0xdd0db1f9,0x7fdd4415,0x5001e903,0x96d73e46,0x4d03ffbd,0x1403b475,0x825eac93,0xee957213,0x83f5db73,0xb131d5ec,0xcc47ac0d,0x3facf327,0xda4eda0f,0xec2f6f85,0x26a8e029,0xb5f8e34f,0x733cb149,0x1dcd18e0,0x949f3054,0xae8c7e7c,0xf45a35f6,0xadb755c2,0x80390eb0,0xfc74331c,0xd5837e17,0x184ae975,0x2dafe309,0xe7a9b216,0xa8ad4ce6,0xf1444ffd,0x5889ef47,0x891016de,0xf56f2e29,0x92a7277d,0x5813c398,0x5648f854,0x56be187e,0xf03847f6,0x1af443fe,0x2cae690a,0xed5942cf,0xc9b52213,0xb9dca9f4,0xa9d7b369,0x9e1116ed,0x47c7e3d3,0xe923229c,0x0fb74df6,0x590524b1,0xcbbe46b2,0x9d0aa771,0x4366cc4a,0x7f212c16,0x2141d3b2,0xd73d7c7b,0x541da727,0x8ab26a3c,0xc2a6ce7e,0xcec4fdde,0x1b4b07e9,0x42bdac0b,0x7266eb65,0xf46131ed,0xaf5bb279,0x5c689723,0x05f28e1e,0x86705ad3,0x73996966,0x723e7968,0x616f03fa,0x5cdbc1d3,0x7c8bfcbf,0x44c83c51,0x5f2176e6,0x3386d90d,0xb73cf9bc,0xd29679d4,0xa178dd02,0x2b494f67,0x819ed930,0x92f88349,0xef092d77,0x296d4fc8,0xb3e64b0f,0xb3f9e3f6,0x2aef0422,0x7d712733,0x5a349c50,0xcecfb05e,0x5de14d86,0xd038a287,0x25277118,0x82063e9e,0x7b9b4004,0x7075a8d9,0x91d2be70,0x8d7d1e42,0xe6fddf12,0x9a516a64,0x292def51,0x95519a07,0x485bff9e,0x24fe0291,0xd89bfd81,0x5946c5fb,0x72038a06,0x6a0b8382,0xccc76719,0x92b83044,0xfdd27859,0x296c8014,0xd086f66c,0x0c697e20,0x9325b058,0xcb73a56e,0x679add13,0xf060d5fb,0x8ffa71e9,0xdf2e1aa0,0xcdba2953,0x888f905c,0x608d85c1,0xe9c80302,0x5b139639,0xf43e99fd,0x14803e4d,0x5875fe2e,0x9c53c1d0,0x0667b31d,0x4185530b,0xdd377a3e,0x1e511ecd,0x33c0ed46,0xd69b373e,0xa8f25924,0x427e7525,0xe3605357,0xba48ff90,0x7895ee61,0xd4633ee5,0xda8fd1d9,0xf28b56da,0x851a86f0,0x0375990d,0xd56eddda,0xb0b52746,0xccef721a,0xd915a8a7,0x8fa5d9f9,0x64f59694,0xc9a7405e,0x112edf92,0xe09a6c0f,0xdbd4396f,0xf41a956f,0x8b0084ca,0x7b9b12d8,0xf26535af,0x7069a4a5,0x1b38b0de,0x9163d951,0xd0437c12,0xb4528978,0x46db0ea1,0x275da980,0xdbe7d6ce,0x559c709c,0x0f1ce72d,0x464b6d82,0x7bc68228,0xab75af09,0x29757d5c,0x005fa810,0xbbdb8c34,0x041d690d,0x99a14fce,0x8017e9ce,0x321c3a6d,0xaf090356,0x7f3e1d37,0x6f1b2c95,0xaa10cb81,0xec3a6575,0x1d5f03c3,0xd0e68a5a,0x0d74062c,0xaa0397b5,0x751be3e7,0xf1c69ebe,0x73158fea,0x17e205b9,0xec7cb47a,0xfc039212,0x03536c49,0x7f1691ec,0xf3faac85,0xf2d4feca,0x3ec10ac4,0x0768f000,0x4ccf9214,0x30a2ce88,0xfef34877,0x761cabf1,0xf09bc4ce,0x0beeba01,0x63b78bdf,0xfd14bae7,0xfdc56fcc,0x0b32b335,0xf96e9343,0x2103137f,0x0e80f13f,0x03a3ab11,0x037c2b4f,0x0cdab567,0x7d1f6d2b,0x2c40ee00,0xb701e531,0x39cd9f4d,0xd4a70505,0x29332804,0x6b5d7a58,0x0874172d,0x0a84ff96,0x4b644ca0,0x5586e77e,0x5f69d6ad,0xf0c46cde,0xb0353635,0x67aae2d2,0x64b5f529,0x7dd28602,0x392e8958,0x56679015,0x5e3d0e48,0x619bddaa,0xa9b36090,0xef464e3a,0x1185b6a4,0xadf9e771,0x2134e82c,0x1d027284,0x4cd67caa,0x25619bbb,0x5a26a7ee},
{ 0x7cbf7fe1,0xe408a357,0xf6876d84,0x483720e9,0x2a907692,0xac937a28,0x02109214,0x8ef43cf1,0x60c212d2,0x287a673d,0x4d70488a,0xc7ddc12f,0x207b3be4,0xaea6ca86,0x6a7567ab,0xca04eb4f,0x1252f4dd,0xec40d968,0xa6cb5444,0xd85a7b6f,0x3c0161fb,0x42568d95,0x26c230aa,0x595a8ca1,0x7065ca86,0x9917ce7c,0xdac78384,0xff36c5d8,0x135de9df,0x78347f2d,0x2b23ba10,0xe5a946a9,0x68b605ff,0x22fe98ab,0x0614042a,0x925b2651,0x7f12ed49,0x5e62a658,0xda40519e,0xadae099d,0x76e701f4,0x91925f6a,0x9fe5dd1c,0x8e3deb7a,0x623c6fb3,0x23cd503f,0x8f71503a,0xb61cc29b,0x61e07c22,0x34ee290d,0xfbf36ba8,0xe234b75c,0x5f8b9575,0x5d55e496,0x71051dfe,0x99163948,0x8cbea6a8,0xd479f52f,0x4e2324c3,0xb8cb50c3,0xd3819761,0x5c72344c,0x54b46d6f,0xcd6c1b4f,0x5e9d66c9,0xdce217e0,0x58381c33,0xae46d09e,0xcc9aa535,0x49b83794,0x4575bb75,0xa44e3646,0x8da0a54a,0x92257d49,0x23a910c7,0xde35d6a7,0x1ddd18e0,0x7b97d43c,0x285f915f,0xe973f3ce,0x15a968d4,0x0ebe76ab,0xb115e11b,0xab96b91c,0xabb5e84c,0x77518e5c,0xb11d2bc6,0xa5da1eb0,0x7c63fe62,0xdaf613ca,0xca633a62,0xd1543dd7,0x92f8036d,0x93f8660a,0xe8dbb2e8,0xd2a937b2,0x1c32fa20,0x0dc0a055,0xad94fbbd,0xbc09b914,0x3e1048df,0xf4e68406,0x9e4353c4,0x88938fec,0x214741d9,0xf54d1d03,0x53215647,0xf41d2c69,0xf6e00cda,0x065493a2,0x280b128e,0x2964b818,0xa81a0b4d,0x94d53709,0x72a86aa1,0x02d5aab6,0xce8a3721,0xc74c0b65,0x25b7a9a7,0x8c34517b,0xc0d0edc0,0x55f8bc66,0x03d22b23,0x70931c21,0x77a87f4b,0xb1933f73,0x3a0d6582,0x05332aa6,0xb3623c90,0xd6e40dc4,0x8d1480e0,0xe9c03489,0x8d77d8e6,0x2e0b02fd,0xc178e140,0x3ccdd0cc,0xa6a47de6,0x25c0d612,0xd93ed3bd,0xa96042fa,0xb9dbb97d,0x765120a3,0x806db717,0xf057af19,0x1a26fe0a,0x9f9b8604,0xd28616f4,0xe26b1f4c,0xe4501941,0x59488d9b,0xe8a45230,0x1901d086,0xbea29cc5,0x7b70f679,0x311d39f4,0xd7d07c56,0x79915ce0,0xb0485139,0x49eb6eac,0x1d8a9115,0x53e960e5,0x76e18055,0x2d23ffd4,0x5f804e20,0xbf8f2adf,0x5e5a322d,0xa9090f0f,0x584da454,0x8ef3c903,0xed33eca5,0xd053bc42,0x2ce1286d,0x231c1224,0x7cff243c,0x6490034b,0xd9d13d46,0xeb5a20a3,0x78a2dd5a,0x418e25d5,0xa078031d,0xc8026393,0x8a4534bb,0x4cd8440a,0xaee8ad85,0x850d6d21,0xfbf500b5,0xc4e3cb5d,0xd2f796c6,0x91842822,0x9f22d36d,0x95c4dfc3,0xfee9d9b2,0xab331f11,0x340d3f18,0x7933feb8,0x953a9110,0x554d3287,0xfc92932b,0x94c7ac52,0xc3f7c34c,0x74c1a6a7,0xaa24cbae,0xa3e53a99,0x44281a5c,0x914aee08,0x62e1668b,0x55d9948c,0x104a3140,0xfe7d9b58,0xcae83941,0x1333b70b,0xab66ca26,0x21cc791b,0xd6c9bdc1,0x884e4ed6,0xad00b957,0xddd29f44,0x192ec0cc,0x26b3b098,0x2ab5bbcf,0x0b1700aa,0x559b9c24,0xcc8a0806,0x4d040a4f,0x99f24a02,0x7a7777ec,0x8f0412f4,0x67340878,0xedb5ca34,0x067165c0,0x8c08a9ca,0xfb1011e3,0x86df4602,0x8b661c94,0xb34bb416,0x6364a9b5,0xab894da0,0x9a11f9cb,0x26a6e353,0x280dd476,0x26279ff1,0xddcd0b91,0xf444265e,0xbb3193ed,0x9435d3c7,0xc05f43e7,0x3263d1b4,0xe637155e,0xadff751a,0x03448954,0x1a3e83e4,0x32793aff,0x1127591f,0x92b6c992,0x4fff6a86,0x8fd1b744},
{ 0x2cfb8dac,0x2883260d,0xf763ae4a,0xf22e47bd,0xc9682b2b,0xcfc86d47,0x36ecd213,0xd6704f2e,0xeccfa6b0,0xcefebc9a,0x5f22ec78,0x9afdeaf6,0x42fc6e06,0x48110d31,0x9f6368e3,0x3be58a1a,0xb4d1b5d6,0x25f739cc,0x308b382b,0x396e3a55,0x44bcc53b,0x5e3cc194,0x02fb60c9,0x1623fd46,0x568cfa40,0xa78734f9,0x9057a632,0x1f9b8d89,0xcf194eeb,0x43c0c48d,0xcdfcc3f0,0x50af092c,0x67a9ba24,0x7db5088c,0x3c4645cd,0x3174a756,0xd8ed97cd,0x6eb7ee62,0xb76ebc95,0x1dc215eb,0x691cbe47,0xd1b31f92,0x8bbaabc6,0xad5be992,0x84e386dc,0x6c5f1020,0xe4cc7597,0xbbdc885c,0x55c87314,0xbdb9b71d,0xa22e9ccd,0x0ebcd496,0x5daf8779,0x0c3fae0b,0x422d74b4,0x7c548480,0x4f2a9c29,0x8ad6a6c6,0xce680270,0xf81c8c7d,0x1725fa8a,0x585b3c71,0x611ef3bb,0xf10db35b,0xa7e202dd,0x8e91f3ea,0x11474130,0xefa78794,0xccf28bed,0xf33c78c3,0xdf29ff8d,0x0f0d3d8a,0x703f4ad8,0x8d328f36,0x9b40a698,0x4a0011ad,0x039346ed,0x0ec4cec2,0x540e89f2,0x2ad87ec0,0xe8ada8d0,0x1a8100f4,0xd1f38ff9,0x3705c296,0x54e53e07,0x95a7ff81,0x31b1fa97,0x96a4097f,0xda570a51,0xb2d7b627,0x2033e666,0x374a1059,0xa245658f,0x4452c456,0xc2ebea66,0x661183cd,0xa18c554a,0x068824f0,0x361b4f0a,0xcee39771,0x6fcc56cd,0xea08bb55,0xefd201ae,0x7f100dd4,0x55141fcd,0xb8af9c39,0xdf4f5b6f,0x6aaa45ef,0x58da900c,0xd78a8b35,0x4de57e17,0xd98e9556,0x5081ac97,0x7cbfb457,0xd82f6a1b,0x206fead3,0xfa1e59fe,0x254c37ed,0x33e6593d,0xc1f38110,0x2f1da6a0,0x17cf65c0,0xd9bcc89e,0x02111c9c,0x9cf02e0e,0x352144d8,0xe0df3c24,0x0f2f470c,0xd82690fb,0x23ef3aa1,0x954f4ac2,0x69390302,0x561e5ece,0x838402c7,0x673d00d7,0x31233d86,0x4a00ac63,0xad4c3bae,0xef2aa88d,0x748ad4d4,0x6fb9a67f,0x14fdcd7a,0xa5425042,0x1ba48b41,0x9dca1087,0x37fc83a6,0xeef6d8c7,0xa0547913,0xd8a2ea58,0xf7caaebe,0x86cebfe9,0xaea31246,0xdeaeb40b,0x15f475ab,0x5bacddb3,0x06f555cf,0xbc16e59b,0x6c560369,0x182d0d03,0x6437224b,0xf2af305a,0x720360c1,0x8580ed62,0x2c5044d8,0xb8332d4a,0x5918b36d,0x7cccc514,0x4b2527d6,0xe175a4d0,0xefd3e9bd,0xce993214,0x5a4a20ed,0xfdeeddb5,0xc42cf783,0x473d3ef9,0x81beb4e6,0xc961d1cb,0xcc48bd35,0x59bdc12f,0x9a057bc1,0x8937a143,0x8c893f4d,0x17024a0f,0xbc11b2b0,0xd1400afb,0xe74c2a03,0xecb9ee60,0x7a4e1a16,0x3bb72f8d,0x3e25b3ba,0x4deff892,0x01258bb5,0x4c399f7e,0x00f94130,0xba13e6c0,0x35f38692,0xe91310cf,0x616ea7c1,0x5c99b5b8,0x1c74a461,0xfe9d526d,0x22be65f2,0xf9e9b83c,0x42a79199,0x7efd0ffd,0x0a4780a4,0xb9a15849,0x62bf06bb,0xc4b47f50,0xbce0f7b0,0xea4cbbaf,0xc658ff8d,0x57e12ce4,0x2608beb9,0x29d8dad9,0xf38abbef,0x3e3affbf,0x8579ac52,0x9643a218,0x8dc0abd8,0xb00ba3a2,0x1da262d5,0x17bc926e,0xfd0100b1,0x114ebbd0,0xec2757e6,0xa3a398d1,0xbf494c2c,0xbad1f87e,0x4d7abe5d,0x381fecaf,0xabded770,0x08fcc265,0xe55d369f,0x7049c06e,0x4f6f5ece,0xdb6813a9,0x310af4b6,0x95c96869,0x22cab114,0xd976d5bc,0x69c04232,0xec0db80e,0xb6778455,0x8e2e1018,0x504d9a47,0x169919db,0xb1389fcf,0x11b7fae0,0x5634b126,0x96501e43,0x565a5ce3,0xdbbf5fbf,0x11e30be5,0x246b48ce,0x5543851d},
{ 0x2a42a797,0x1cb48ea3,0x32ee51f7,0x31925133,0xd12f930d,0x88abacff,0xf7766ed2,0xe67ece44,0x6596220c,0x838cf99d,0x2a554783,0xe196a8b1,0xa826aea1,0x7995409e,0xe513a234,0x8f026070,0x94ce56b2,0xc077133e,0x1b90b59b,0xe651ff41,0xc61d3d6a,0x065f998b,0xd96a487f,0x440d3ecd,0xc665f071,0xbf171672,0x8da71ddb,0x8b43a94d,0x9c552d50,0xb0b44050,0x5ca8b9a2,0xee820c21,0x80cb1493,0xf3c539f3,0x653a194d,0x3afebb18,0x992c5a17,0xec5c28f7,0xc7d91320,0x5674b5cc,0xfd0e1480,0x2c7aab30,0xade731ce,0x687fef59,0x9650a72d,0x10c68050,0x6852d7b0,0x55bac42d,0x90514157,0x29470831,0xdbfd4138,0x50fcf6f2,0x8db626b5,0x94df089e,0x09eb3cbf,0xc4c0abb6,0x9c7f9a30,0xc12b6804,0x54a8487e,0xebd12815,0x1187f6e8,0x1b2a4625,0x21a7dd64,0x33e297c0,0x7e82ed1d,0x062fecb3,0x4c71997f,0xc05941f8,0xefc5e7b3,0xf5d52264,0xe750b7c0,0xc174929f,0x50265269,0x32d7bdaa,0x3dacbe79,0x96e1cb98,0x8be9bf3e,0x4db540e1,0x4de60272,0x02a55bc7,0x23688c42,0x4c8c75df,0xdfebe133,0x77840545,0xa133b6b8,0x4782ff87,0xcf25d145,0xb3298353,0x8d47d4ee,0x6315f5fe,0x768f2267,0x59751bef,0x0399cf44,0x320c3144,0xb124020c,0x3c7a861f,0x7c5cf959,0x9f308c64,0x55d35120,0x00b16cb5,0x9b2f3f6e,0x25e79751,0x185cc65f,0x92f41a90,0x0a2f8473,0x977134e7,0x8f1717c1,0xfa3223f0,0x35ecbe26,0x4e69c338,0x0be57af3,0x2f561963,0x4c6cbcea,0x37bdbd80,0x9d5e0a72,0x48f2ed07,0x18b38961,0x13abec20,0x82c695cc,0x42f86b02,0x7a7315ea,0xd341151b,0x958a10d8,0xef748b06,0x6efa1d0a,0xc2b72091,0xd92854c0,0xc2d248f9,0x38f839d9,0xaadd8a9e,0x19f6dc59,0x71db9cce,0x7859fec7,0x038fc14a,0x09402134,0x0c3e9521,0x00e0c935,0xe8565cb3,0xeada0f37,0xe9c15bbf,0x5f3176e6,0xdc8e3d65,0x31ef169f,0xcfbfbfec,0x1966e014,0xa5ce377c,0xccff0b37,0xeced4442,0x5cf62c4e,0x7393229d,0xe552d2df,0xbe8eb1a0,0xa7c8b5bd,0xff0edbbe,0x1947b0ec,0xeaf4a3a0,0x5dbe6996,0x1bd30715,0x9bb43ba4,0x06111152,0x9791fdd2,0x67414b72,0x10e82cc7,0xdc2de599,0x1158b5de,0xd76b4796,0x1eb90ffc,0x83d30306,0x2edb5d94,0x38903d0e,0x840de630,0xf45ecd23,0x4f5dc06e,0xf155b751,0xa7aab9dd,0xc4fda44a,0x7489a0a6,0x6a84cb66,0xf6333bea,0x840ebeaa,0x9f094907,0xc2fb53d5,0x5966735d,0x3ee9288b,0x3d4c774c,0x7eb7972b,0x6133b009,0xa4741b5e,0x12d77494,0xde2b66a2,0x12879add,0x8333ca33,0xc68d0127,0xd24a3239,0x6dccbd8f,0xab6fbbc5,0x93d3fd0b,0xc0baa1ce,0x68150631,0xdd9b445e,0xd14797da,0xa67bc051,0x1ade7fa8,0xd8f892e4,0xec9a6b9a,0x27a9810a,0xe7e8c2fd,0x99219d36,0xc242acf2,0x67f027c7,0x8bc713a9,0xf9ca72c8,0x09047381,0x459f5d06,0x14968b8f,0x14a237e1,0xa1cc4a55,0xc2a21efe,0xb1e15816,0xba370e1b,0x44b8ba9d,0xde03ae32,0xebc60537,0xf34019ca,0xe9d7aad4,0x22762661,0xee80b28b,0x97a5528a,0x1dcfdccb,0x800338d7,0x231566b7,0xeda83d90,0xa8c66794,0x91c31c2d,0x0fc9ad03,0x66c33bcf,0xcbff2054,0x1cf92e5b,0x2a7fa304,0x29ee40ad,0xdf7bdd7e,0xa391aef7,0x15954348,0xa8e07a8f,0x9a93dc3f,0xcc8434ef,0x68f5cf04,0x35cd18ed,0x3b9d98ed,0x4fba9bee,0x45ef094e,0x0476af81,0xdd757d05,0xe8163ee6,0xfe8e22e9,0x3cefaa4a},
{ 0x0ebda7c5,0x8b1d6385,0xd7313fe7,0x8a595055,0xec56a15e,0xfb11eca6,0xb35e3e32,0xebacec5f,0xb88bfab9,0x2856bd5e,0xec5f3180,0xa1e4090e,0xdf0c8139,0xd812bf60,0x7c57f8e5,0x940152b8,0xf93f8613,0xfe5bc3f8,0xffd80755,0x40ce151c,0x0376d337,0x03d03bd1,0x0dce3b23,0xd538009e,0x2ccb81a4,0x659dd10e,0x40946d6d,0x97968c9e,0x6c559989,0xd8048a11,0x5ef603a2,0x436a8bcb,0x2948e694,0x279f105d,0x8a9c0a4f,0x6a1b295a,0xc3f5af62,0xf26d1c64,0x55b9b848,0x4b7a8fc6,0x5aae28e4,0xebce80b0,0x57387dda,0xda5dc923,0xcff2e7d8,0x6b25f4d5,0x380323ce,0xeea59873,0x63711a4a,0x2072d840,0x44e2c2ec,0x4ae3f19b,0x8443a76f,0x268aa8f8,0x6219a9e8,0x4dd72c0e,0xa2558511,0xf0ae2fba,0x00c55a1a,0x864d8804,0x38e443c4,0x41332256,0xbe155417,0xf3f1757f,0x72f895ba,0x0791b130,0xf6dc74d4,0x0551481a,0x17e058b8,0x17720c30,0xac027176,0x179a1e60,0x9d2ad9b2,0xdfaadf15,0x042cd7f0,0x499522ac,0x87939cbe,0x2b4493db,0xb721a976,0x611cadaa,0xc7c8541f,0xb03a42d7,0x9753d684,0xea18118d,0xe0e0c9d5,0x1fc521f4,0xfd7fdfdc,0xdab993eb,0x556785e7,0x8d0dbb7f,0x9cc75d8e,0xc6a4e778,0xe58d44dc,0x42cbb478,0xe778feb0,0x4d343684,0x76e45902,0x8892a2cf,0xde711ed3,0x8667c574,0xecb6686b,0x1347b015,0x59843105,0x026db7e0,0xe7ba8c5f,0xf4d8803b,0xddb0271f,0x6e5bb6e2,0xc66a612d,0x7ddc881c,0xb0a8f3d2,0x78ec16fa,0xa5c9aa5d,0x8dc8e165,0x1a8ad58a,0xfe40a4bc,0xa4be668a,0xfcdee06f,0x14898bcf,0x3fcca33e,0x7175e832,0x7e4ed61b,0xdb2056c9,0x91879dcc,0xfbc4645b,0xbf45c163,0x4e1e2f65,0x9f476e52,0x3810534a,0xf0f457cb,0x942505b3,0xe9c82a5c,0xed2ef2f6,0xcafd216a,0xd1b45e78,0xbf2442e5,0x15f3e88a,0x1a9b37e1,0xf092c407,0x1ea06d69,0xbb7b477e,0x01a13fb3,0xce301824,0x6aab26d9,0xfc78534d,0xe2898b95,0x1d84b1b1,0x740ad910,0xb90fd023,0x583d3fd3,0x032a19e1,0xe9a33750,0xb082f185,0x2e854918,0x1242c0c7,0x057e4237,0xfe6942e3,0x9379106f,0xd3d9e998,0x589eceba,0xe12b68b1,0xc72b10fe,0x9ec972e5,0xd8ca0c44,0xc6a7cf62,0xb109cc61,0xb6dc0ede,0xcf628c84,0x71b0b228,0xf8035e1f,0xe3c4150d,0xd0b4bf9a,0x45d1304c,0x4cb4b41c,0x3ce6badf,0x98d6df62,0xcecc279e,0xf5a51fd1,0x83c55d0b,0xfeba266c,0x412c8380,0xdd673f0a,0x4c9e87ca,0x608e9df0,0x11df3f7a,0x530e154d,0x770158b9,0x35e4feb2,0x0c5aee08,0x60bd9219,0x09f84c3b,0xda91640e,0x6b2b85c9,0x08919a18,0xfd647864,0x6bcff8e4,0x44700fff,0x8284ac38,0x564d9c06,0x64ae8c2f,0x2c45ac0b,0xe821ae60,0xf7cf841b,0x47b5f64f,0x1911bc53,0xde4d26eb,0xa53db09a,0xd00c6c75,0x3f5a7662,0x414cd58a,0x727f1a8e,0xcb8dbc51,0x9f23fe67,0xb3647b81,0x51668281,0x3bba0cbf,0xac009537,0x9658e8fd,0x25ae7420,0xad683786,0xf579c39e,0x3458a2e6,0x992f1082,0x151e3e07,0xd446f214,0x0be5bb6d,0x277b3b81,0x0264c603,0x55a5084f,0xe2ab9c34,0x3deb6ff8,0x1ec04beb,0xcaff69b3,0xc2898881,0x8cc53ce2,0x8aa13fd1,0x4244c16d,0xfffafc4b,0x31e81f71,0x2a6533c5,0xff0e807a,0xe159b044,0x104a8a92,0xa132d98e,0x95c45187,0x3da0eedd,0x43be748c,0x7e35bbce,0xdcd7680c,0xf681c309,0x4cb4c365,0x4614c9fc,0xd721a477,0xb4e60032,0x5945e3d7,0x3285e7e0},
{ 0x22dec7d3,0x35460c9a,0xcb70caad,0x93b08382,0x9c09e786,0x5ac74cd1,0xe1e47304,0x153f45a7,0xbe4255f0,0x9326aaca,0xdbc736c3,0x3e1127e9,0x26a02a06,0x6cc66c5c,0x78047833,0xd2352ef9,0x4a8f80f1,0xd32fb729,0xe1dcf4e3,0xb36d0a62,0xe3790691,0x2dc910b0,0x4c5bddd0,0xe6c315f4,0x293b7cbe,0x123d371b,0xc9140cae,0xc6158bcd,0x7ea27bb2,0x672c2329,0xff2438ef,0xdfc02c14,0x7ccbdd71,0x1fe39628,0x51660912,0x7c55e684,0xd95ad64d,0x5d2e732d,0x52614bf6,0x2d3bae83,0xabd630b5,0xc3653dbb,0x40ee2d6d,0x26a95be5,0xded9e84c,0x6e77643c,0x326e661e,0x3a147df8,0xdfbabfb7,0x5e89f47e,0x8f00c552,0x11342fba,0xca447b80,0x3e69c0fe,0xcda1df0f,0xfd1eebc7,0x498dd1eb,0xd4935c85,0xc2d68a90,0xe05c0102,0x839d9a9c,0xbcca0029,0x475e0e51,0x9379fb73,0x38f09a7f,0x18a20b78,0x7eff0a84,0x000971e3,0xb21f8410,0x16731c0f,0xe05b48e7,0x709bfd09,0x0c95089e,0xbf55009d,0x3c6dcf30,0xf24d292b,0xe78d6b30,0x72321d2e,0x2b62cafb,0xd4259779,0x5bb0e6f0,0x1d87502b,0x04c3015d,0x9efe7ab0,0xe4b1b9b5,0x43ee38c6,0x989e2245,0xefb22602,0x27130c57,0x49c4026a,0x02aaec00,0xd953a7ae,0xef31f73d,0x441257f9,0xcd60e664,0xdb4dcdbc,0xcff03525,0xffbb2df0,0x1ac494d5,0x2c94c167,0x89fa0f0c,0x405c7b30,0x1176b703,0x0b9f28ce,0x0539128e,0x92879579,0x15f72ee7,0x54ba0130,0xdad8794b,0x8e4fe7c9,0x6580c982,0xa63ff7e9,0xf38050d2,0x8b1288fa,0xe2f6ed02,0x5ace3d32,0x53fbf714,0x034c59a8,0x5e191d17,0xe3bd57c3,0xd7523e5d,0x81442774,0x1acde536,0x9e8b4577,0x9f891303,0xa00733d7,0x61ed4a0a,0x070a2050,0xba6c1213,0xaeea5a49,0xe7ba07cc,0xb3376a00,0xa8ea6465,0xa52d2d32,0xb1a55efb,0xfd8f1119,0xee0700f9,0x8fd189a7,0x7c0897b2,0xbe7f8487,0x1015cfd2,0x9bd27bed,0xb1ab3b15,0xc4ae5b94,0x9e963c37,0x83eecb74,0xc39e4298,0x71bab24a,0xdb9b44fa,0x6d67d5b3,0xbaa087b6,0xc8fa1575,0x45d73fe3,0xb42ece9c,0xcb2ec6ab,0x3acd650c,0xe8b61f55,0xb45b9a31,0xba3a7635,0xf8b60397,0x7c809580,0x9a26a740,0x28b29682,0x64a7fdcc,0x9e5a281b,0xfe52b26f,0x1794ccfc,0x372e0b46,0x1584b4cd,0x61182676,0x99507faa,0x2241455e,0xd8d71d52,0x337ec8a4,0x591dd075,0x1fa82b28,0xc4931897,0xaee32baa,0x55a583dc,0xa544760f,0x48b12c82,0xd5b6d03b,0xbd305665,0x42da1184,0xd26acfc9,0x7d9ca08c,0x9b85fc82,0xcc4d99a9,0x3b770529,0x4ff7ec94,0xea1bdde5,0xd9290bbf,0x9a553d6a,0x1d10b1c4,0x272ffb2d,0x32548a8c,0x430566bf,0x82d5f3b1,0x9db38be1,0x813e171f,0x477dd3e3,0x6d7d6932,0x241f3196,0x7edf32f5,0x25d6f931,0x6f16578d,0x75ca4310,0x070d2e67,0x66440155,0xb6b26627,0xa148998e,0x24fb86fc,0x8f2c9f18,0xf5cd9aa1,0x12adde72,0xa5a99e3f,0x00739a2a,0x35a22746,0x438806e1,0xac0ea297,0xbd57d4d0,0x95413f4d,0xaa9d80a7,0x94baa3d2,0x2665f595,0xf42d1698,0x065e74c8,0xa6082fa7,0x16a83195,0x360b87f8,0x6a626838,0xc39e36f0,0xc8a72aff,0xe317e5fb,0x040cef81,0x6c4aaa7e,0x5a9a4f23,0x48fdccc4,0x5077cff6,0x77c351f6,0x7def3aa6,0xae27dbc4,0x8fc59f48,0x9779a7be,0xf2a03844,0x7f5ae2a8,0x73b48b18,0x0eef9eb8,0x3b754451,0xd302edb5,0x340afe44,0xe50d4918,0x947dc224,0xabb80c19,0xeb5c7f27,0x84e3e513},
{ 0xa5da43cd,0xc708d46d,0x7ad3dd74,0x499c534f,0x358c18ae,0x3d378fd4,0x577ae191,0x118750a3,0xcb5d5c81,0x0f6f424a,0xab3e19b4,0x185538a6,0x076da2e5,0x6df73cda,0xd61d1527,0x0e9c0492,0x0ed76317,0x908aeb54,0x98045cd3,0x585a9dc8,0x013cfd69,0x01258cbe,0x7fe6dcf5,0xa2861086,0x51f75555,0xc156a0a5,0xdcdbf2d3,0x5f3462da,0x03879f56,0x5755e7ec,0x94e4d761,0xd9207a5c,0x284ab97a,0x0b63adcb,0xc774b3ca,0x42cf7785,0x4f906e21,0x3d80f32c,0xa1de44d1,0x73733e34,0xa0f0b8d3,0x1f4f741c,0x0f7dfb6d,0xaafaa58c,0x7e661fc1,0x729107a6,0x7109424d,0x99f354d7,0x82f5b8e0,0xf55c5ee1,0x39d6bbcb,0xcb49a0fe,0xa83f934f,0xbc0998cb,0x10073272,0x7cfa3991,0xef426d17,0x71b070bf,0x8ee8e085,0x77436f2b,0x72a7e1f5,0x6afa12bd,0xb0591472,0xb82e62b5,0xaf9ffa99,0xb4716da8,0x1728c3cb,0xad970769,0x1391231b,0xa48c1281,0x7f9546df,0x972437c0,0x127f53b4,0x6d580232,0x618c2603,0xca755d97,0xa91a1ff1,0xc3ef443e,0xb28122f4,0x2d0d6cc4,0x2e14cdb2,0xad6b826c,0xd1dc825f,0x74c4f07d,0x25f20619,0xfe1ec5dc,0x69796e2e,0x9064dbcf,0xa4fc5752,0x7305de62,0x55e7b44e,0xe2076948,0x2e11d037,0x05525650,0x0ce678eb,0x37d48f13,0x0d3027a8,0x6225f95f,0xcb76838f,0xb4134256,0xdb8b1857,0xb2e60673,0x2b727623,0xaff8d424,0xdb489353,0x94bd39a7,0x1a9522a1,0xdcfb6332,0x99fb9ed2,0xee19f7ae,0x158357bf,0x7f26b6d8,0xd54c27ed,0xfded3ee7,0x22a4db65,0x90a088bd,0x44ebc28a,0xb50b4222,0xb4c81a5e,0x984b758a,0xb9414a00,0x750d3a94,0x66e184e6,0xa782614d,0x7f070ad6,0xcd7340ac,0xbc5641e3,0xbd878790,0xb6109161,0xf5311fa4,0xd0e07f36,0x75e17cc3,0x5a14daec,0x5c98d55a,0x388e3b7b,0x51327b6a,0x7827a581,0x2c31bcb8,0x56602b18,0xb5528ea4,0xbaf50756,0xdc722c0c,0x24acc191,0x3cb722d8,0xca449462,0x20ea8eda,0x84e6edae,0x8993b17a,0x7a555c86,0xc1953847,0x8b82cef0,0xb0b7a038,0xd435683e,0x3e479c2b,0x64f33d60,0xae6a6494,0xe8f2dc9f,0x77eaa379,0x9776ef5f,0x8a7ae839,0xec9a9c26,0x36a49e19,0x8a9b482a,0x2ca91076,0x54ecf0f8,0xc9f17bb3,0x5b8a7749,0xe9fb0535,0x37a9aa85,0x024e55bf,0x14466513,0xcd7873f0,0xcf5e1ea4,0x755d2219,0x13c9bb7a,0x09f6ea38,0xa13852aa,0x58a618cd,0xc3715c2d,0xd16d6e42,0x25819c33,0xcbbce29a,0x2af168cf,0x3c6a7958,0x19ab8382,0xe644e12f,0xff7a34e9,0x76bdca9a,0x087425a2,0xf17f40c8,0x0ab80c23,0x91dca0b4,0x1b98163d,0x542e7ea7,0xa114ebb7,0x778d74a6,0x132c32a8,0x51f1e388,0x2f7e99a2,0xc3b27e5a,0x81d2dc70,0xdc40f563,0x4ae2ed57,0xab3832c4,0xe414a474,0x403e2c6a,0x9a46c8f7,0xe85f1166,0x27ec1fa9,0x82b7dc4f,0x5110507d,0x9e4f1605,0x7f9e86db,0x6609af97,0x80c2e41a,0x7d463c92,0x2d3c8824,0xdeb5368d,0x8dbdfbc1,0x2361845e,0xdadd491b,0x0a7b94c1,0xc6859c97,0xf41bd4df,0x839c89cf,0xc8069070,0x879a9ea7,0x64662c60,0x9149866d,0x53f79710,0x93b022cf,0x496743cc,0x7f4a0764,0x41c68062,0x807d3e3f,0xbbce8a36,0xb4226441,0x4cf8c758,0xbca89d42,0x64edbf10,0xcb78690b,0x21cf0264,0xfb00315b,0x2b15a1fc,0x2ba209d3,0x00c398e2,0x57593c23,0xef83c2e2,0xd7b2f768,0x69127bc7,0xf017ea01,0x774a1ec8,0xc0b865e5,0x7c890eb2,0x50025c95,0xc8b59fbc},
{ 0xa30af207,0x0b246d35,0x2b450cfb,0x5fda2e42,0xf41c482b,0xd6be0faf,0x54f78c24,0x4301a0b9,0x49cfb544,0x70df5219,0x654f275e,0x548b2727,0x4daba644,0x80017cf8,0x2a1f00b1,0xc2bf4ac6,0x0907c1e5,0xe4af8006,0xd3766e5f,0xad9757d3,0xcac3f124,0xba0c9225,0xa419884a,0x4b291673,0x6b0c6277,0x8cbef392,0x4f23209b,0xce93a82f,0xa7ebdf3b,0x450e2d60,0x1d90cfe8,0x3c4ba7dd,0x08093526,0xf0a26c26,0xde81ad68,0xe0a94366,0x0153611c,0x3ca9e1ba,0x4ef2bfa1,0x09c723cd,0x28c8c381,0x1fafb15d,0xf863cfa3,0x86355e00,0xca0069c6,0xed55ae06,0x4b9a4aa8,0x9c9be11b,0x021e19b0,0x7ca91993,0x38693e53,0x0e2bcdca,0xdb62d189,0x150c71f5,0xd5255054,0x9f4155da,0x032d5813,0xdbe760dd,0x815b832a,0x14b50b4d,0xd7ed6eb3,0x685e6d9e,0x0df31f18,0x40089689,0x58179198,0x7ae09603,0xace8e884,0xcb9ef844,0x4a01153e,0xc74aaeb7,0x8925006e,0x959c20fe,0xe6b199b6,0xafdf77cc,0x95fe6980,0xc4e83cee,0x616e43ac,0xb115f9bf,0x9e0c4627,0xf44d37ad,0x8f93ab81,0x94c44046,0x4fc82b05,0xb35ed476,0x92e343d3,0x75cea276,0x31b8b8c5,0x4801a3af,0xa8b5fdbe,0xa4613b6b,0x4c41abe2,0xcacd9958,0x76a8f484,0x89b81116,0x80e223a3,0xbd54e37f,0xf91e28eb,0x57bcb86f,0x13cb3780,0x0ee85528,0x8c3bedaa,0xfa8fb317,0x0297a73c,0xf6532e1d,0xf33ab212,0xacad7e15,0x41e3e6cf,0x683c05ff,0x87ef3226,0xa0ebf222,0xaef9ed1f,0x4b2cfbbc,0x73529d63,0x253ab841,0x58f4a0af,0x1d20f7eb,0x1ef6991a,0x844b0e0e,0xc0eab52a,0xe54372e7,0x83febee8,0xfb5450eb,0xd855cfc4,0x44e94016,0x4b71431d,0x73aab379,0x970b87c2,0x10e2b7ab,0x5ce5c5de,0x39531795,0x850bda21,0x09524653,0x36facb99,0x3ee7b405,0x5ab4dab2,0xc4bf503d,0xe796dd25,0x6af29344,0xebaa74d9,0x8fc3b438,0x6b383b6c,0xb5f3b6cb,0x88eb1685,0x4df68f59,0x279f8583,0xb715fb09,0x1298569c,0x3241b492,0xc2c9520b,0xf34890da,0x2a5f64bd,0xe9fc9f40,0x0b597db1,0x2a982015,0x8be38f09,0x8569abf9,0xcc75788e,0x3c701339,0xace7f4af,0x3785e22f,0x4b3ba330,0x2b11758b,0x83967126,0x082c861e,0xcbd3c94e,0x1b0a5bd4,0xc3c7ed39,0x3ea4123a,0x02a53dc2,0xefe15ba6,0x0fb8a177,0x2cb72d88,0x46825c05,0x33a225f0,0xcf1c165a,0x6a0221a8,0xf00d2d5a,0xf2cdefd1,0xcf0acf1f,0xce18e8e4,0xbfdfcbf7,0xab7b94fb,0xbc054304,0x6b6027f1,0x7268b4a5,0xae1aafaa,0x8ac43775,0x3ed64d87,0xf5347d4b,0x41be8166,0x0778bd04,0xd932cf1f,0x6857ae86,0x044b2f7f,0x807b154f,0x478f16e4,0xf371eace,0xbb493375,0x82ea9903,0x4d9da42b,0x4718d653,0xe055b94d,0xfd4b7b8d,0x0cd1baef,0x4c975b2d,0x8124f046,0x55f9dc44,0x60395a40,0x58f094b0,0x25f920a3,0x0fad9c8c,0xf2a33509,0xc9446e72,0xed5975c9,0x30fd5f2b,0x92096c2f,0x4346db0d,0x87dd5e59,0x88579351,0x8c5cdfaa,0xe87bb11a,0x788ede4c,0xbc4e8b39,0x4f3899e9,0xa8f98df5,0xefed183a,0xd1fc5605,0x4a53e6ea,0x7f357edd,0x4e38e61c,0x3ffbfdec,0x9034771a,0xaa3d7b61,0xeaf3efbc,0xc1b57468,0x4d7cfefe,0x623ffa89,0x515c36cd,0x5b9d78da,0xe061d88a,0xed5c74a7,0x0d19692c,0xb681ded6,0x7968a2e1,0xa9c5307c,0x7ff66348,0x657c4426,0x276f376f,0xacb2a28a,0x6f960d75,0x967340e1,0xb9220c24,0xc47c4da8,0xccd27f1f,0x726659c7,0xd72ca149}
};
public:
  /*
  Hash() {
    for (int i=7; i>=0; --i)
      for (int j=0; j<256; ++j)
        table[i][j]=rnd();
    assert(table[0][255]==3610026313LU);
  }
  */
  U32 operator()(U8 i0) const {
    return table[0][i0];
  }
  U32 operator()(U8 i0, U8 i1) const {
    return table[0][i0]+table[1][i1];
  }
  U32 operator()(U8 i0, U8 i1, U8 i2) const {
    return table[0][i0]+table[1][i1]+table[2][i2];
  }
  U32 operator()(U8 i0, U8 i1, U8 i2, U8 i3) const {
    return table[0][i0]+table[1][i1]+table[2][i2]+table[3][i3];
  }
} hash;

//////////////////////////// Counter ////////////////////////////

/* A Counter represents a pair (n0, n1) of counts of 0 and 1 bits
in a context.

  get0() -- returns p(0) with weight n = get0()+get1()
  get1() -- returns p(1) with weight n
  add(y) -- increments n_y, where y is 0 or 1 and decreases n_1-y
  priority() -- Returns a priority (n) for hash replacement such that
    higher numbers should be favored.
*/

class Counter {
  U8 state;
  struct E {      // State table entry
    U16 n0, n1;   // get0(), get1()
    U8 s00, s01;  // Next state on input 0 without/with probabilistic incr.
    U8 s10, s11;  // Next state on input 1
    U32 p0, p1;   // Probability of increment x 2^32 on inputs 0, 1
  };
  static E table[];  // State table
public:
  Counter(): state(0) {}
  int get0() const {return table[state].n0;}
  int get1() const {return table[state].n1;}
  int priority() const {return get0()+get1();}
  void add(int y) {
    if (y) {
      if (state<208 || rnd()<table[state].p1)
        state=table[state].s11;
      else
        state=table[state].s10;
    }
    else {
      if (state<208 || rnd()<table[state].p0)
        state=table[state].s01;
      else
        state=table[state].s00;
    }
  }
};

// State table generated by stgen6.cpp
Counter::E Counter::table[] = {
//  get0 get1 s00 s01 s10 s11  p(s01)       p(s11)    state n0,n1
//  ---- ---- --- --- --- --- ---------  ----------   ----- -- --
    {  0,  0,  0,  2,  0,  1,4294967295u,4294967295u}, // 0 (0,0)
    {  0,  4,  1,  4,  1,  3,4294967295u,4294967295u}, // 1 (0,1)
    {  4,  0,  2,  5,  2,  4,4294967295u,4294967295u}, // 2 (1,0)
    {  0,  8,  1,  4,  3,  6,4294967295u,4294967295u}, // 3 (0,2)
    {  1,  1,  4,  8,  4,  7,4294967295u,4294967295u}, // 4 (1,1)
    {  8,  0,  5,  9,  2,  4,4294967295u,4294967295u}, // 5 (2,0)
    {  0, 12,  1,  4,  6, 10,4294967295u,4294967295u}, // 6 (0,3)
    {  1,  2,  4,  8,  7, 11,4294967295u,4294967295u}, // 7 (1,2)
    {  2,  1,  8, 13,  4,  7,4294967295u,4294967295u}, // 8 (2,1)
    { 12,  0,  9, 14,  2,  4,4294967295u,4294967295u}, // 9 (3,0)
    {  0, 16,  3,  7, 10, 15,4294967295u,4294967295u}, // 10 (0,4)
    {  1,  3,  4,  8, 11, 16,4294967295u,4294967295u}, // 11 (1,3)
    {  1,  1,  8, 13,  7, 11,4294967295u,4294967295u}, // 12 (2,2)
    {  3,  1, 13, 19,  4,  7,4294967295u,4294967295u}, // 13 (3,1)
    { 16,  0, 14, 20,  5,  8,4294967295u,4294967295u}, // 14 (4,0)
    {  0, 20,  3,  7, 15, 21,4294967295u,4294967295u}, // 15 (0,5)
    {  1,  4,  7, 12, 16, 22,4294967295u,4294967295u}, // 16 (1,4)
    {  1,  1,  8, 13, 11, 16,4294967295u,4294967295u}, // 17 (2,3)
    {  1,  1, 13, 19,  7, 11,4294967295u,4294967295u}, // 18 (3,2)
    {  4,  1, 19, 26,  8, 12,4294967295u,4294967295u}, // 19 (4,1)
    { 20,  0, 20, 27,  5,  8,4294967295u,4294967295u}, // 20 (5,0)
    {  0, 24,  6, 11, 21, 28,4294967295u,4294967295u}, // 21 (0,6)
    {  1,  5,  7, 12, 22, 29,4294967295u,4294967295u}, // 22 (1,5)
    {  1,  2, 12, 18, 16, 22,4294967295u,4294967295u}, // 23 (2,4)
    {  1,  1, 13, 19, 11, 16,4294967295u,4294967295u}, // 24 (3,3)
    {  2,  1, 19, 26, 12, 17,4294967295u,4294967295u}, // 25 (4,2)
    {  5,  1, 26, 34,  8, 12,4294967295u,4294967295u}, // 26 (5,1)
    { 24,  0, 27, 35,  9, 13,4294967295u,4294967295u}, // 27 (6,0)
    {  0, 28,  6, 11, 28, 36,4294967295u,4294967295u}, // 28 (0,7)
    {  1,  6, 11, 17, 29, 37,4294967295u,4294967295u}, // 29 (1,6)
    {  1,  2, 12, 18, 22, 29,4294967295u,4294967295u}, // 30 (2,5)
    {  1,  1, 18, 25, 16, 22,4294967295u,4294967295u}, // 31 (3,4)
    {  1,  1, 19, 26, 17, 23,4294967295u,4294967295u}, // 32 (4,3)
    {  2,  1, 26, 34, 12, 17,4294967295u,4294967295u}, // 33 (5,2)
    {  6,  1, 34, 43, 13, 18,4294967295u,4294967295u}, // 34 (6,1)
    { 28,  0, 35, 44,  9, 13,4294967295u,4294967295u}, // 35 (7,0)
    {  0, 32, 10, 16, 36, 45,4294967295u,4294967295u}, // 36 (0,8)
    {  1,  7, 11, 17, 37, 46,4294967295u,4294967295u}, // 37 (1,7)
    {  1,  3, 17, 24, 29, 37,4294967295u,4294967295u}, // 38 (2,6)
    {  1,  1, 18, 25, 22, 29,4294967295u,4294967295u}, // 39 (3,5)
    {  1,  1, 25, 33, 23, 30,4294967295u,4294967295u}, // 40 (4,4)
    {  1,  1, 26, 34, 17, 23,4294967295u,4294967295u}, // 41 (5,3)
    {  3,  1, 34, 43, 18, 24,4294967295u,4294967295u}, // 42 (6,2)
    {  7,  1, 43, 53, 13, 18,4294967295u,4294967295u}, // 43 (7,1)
    { 32,  0, 44, 54, 14, 19,4294967295u,4294967295u}, // 44 (8,0)
    {  0, 36, 10, 16, 45, 55,4294967295u,4294967295u}, // 45 (0,9)
    {  1,  8, 16, 23, 46, 56,4294967295u,4294967295u}, // 46 (1,8)
    {  1,  3, 17, 24, 37, 46,4294967295u,4294967295u}, // 47 (2,7)
    {  1,  2, 24, 32, 29, 37,4294967295u,4294967295u}, // 48 (3,6)
    {  1,  1, 25, 33, 30, 38,4294967295u,4294967295u}, // 49 (4,5)
    {  1,  1, 33, 42, 23, 30,4294967295u,4294967295u}, // 50 (5,4)
    {  2,  1, 34, 43, 24, 31,4294967295u,4294967295u}, // 51 (6,3)
    {  3,  1, 43, 53, 18, 24,4294967295u,4294967295u}, // 52 (7,2)
    {  8,  1, 53, 61, 19, 25,4294967295u,4294967295u}, // 53 (8,1)
    { 36,  0, 54, 62, 14, 19,4294967295u,4294967295u}, // 54 (9,0)
    {  0, 40, 15, 22, 55, 63,4294967295u,4294967295u}, // 55 (0,10)
    {  1,  9, 16, 23, 56, 64,4294967295u,4294967295u}, // 56 (1,9)
    {  1,  4, 23, 31, 46, 56,4294967295u,4294967295u}, // 57 (2,8)
    {  1,  2, 24, 32, 37, 46,4294967295u,4294967295u}, // 58 (3,7)
    {  2,  1, 43, 53, 24, 31,4294967295u,4294967295u}, // 59 (7,3)
    {  4,  1, 53, 61, 25, 32,4294967295u,4294967295u}, // 60 (8,2)
    {  9,  1, 61, 69, 19, 25,4294967295u,4294967295u}, // 61 (9,1)
    { 40,  0, 62, 70, 20, 26,4294967295u,4294967295u}, // 62 (10,0)
    {  0, 44, 15, 22, 63, 71,4294967295u,4294967295u}, // 63 (0,11)
    {  1, 10, 22, 30, 64, 72,4294967295u,4294967295u}, // 64 (1,10)
    {  1,  4, 23, 31, 56, 64,4294967295u,4294967295u}, // 65 (2,9)
    {  1,  2, 31, 40, 46, 56,4294967295u,4294967295u}, // 66 (3,8)
    {  2,  1, 53, 61, 32, 40,4294967295u,4294967295u}, // 67 (8,3)
    {  4,  1, 61, 69, 25, 32,4294967295u,4294967295u}, // 68 (9,2)
    { 10,  1, 69, 77, 26, 33,4294967295u,4294967295u}, // 69 (10,1)
    { 44,  0, 70, 78, 20, 26,4294967295u,4294967295u}, // 70 (11,0)
    {  0, 48, 21, 29, 71, 79,4294967295u,4294967295u}, // 71 (0,12)
    {  1, 11, 22, 30, 72, 80,4294967295u,4294967295u}, // 72 (1,11)
    {  1,  5, 30, 39, 64, 72,4294967295u,4294967295u}, // 73 (2,10)
    {  1,  3, 31, 40, 56, 64,4294967295u,4294967295u}, // 74 (3,9)
    {  3,  1, 61, 69, 32, 40,4294967295u,4294967295u}, // 75 (9,3)
    {  5,  1, 69, 77, 33, 41,4294967295u,4294967295u}, // 76 (10,2)
    { 11,  1, 77, 85, 26, 33,4294967295u,4294967295u}, // 77 (11,1)
    { 48,  0, 78, 86, 27, 34,4294967295u,4294967295u}, // 78 (12,0)
    {  0, 52, 21, 29, 79, 87,4294967295u,4294967295u}, // 79 (0,13)
    {  1, 12, 29, 38, 80, 88,4294967295u,4294967295u}, // 80 (1,12)
    {  1,  5, 30, 39, 72, 80,4294967295u,4294967295u}, // 81 (2,11)
    {  1,  3, 39, 49, 64, 72,4294967295u,4294967295u}, // 82 (3,10)
    {  3,  1, 69, 77, 41, 50,4294967295u,4294967295u}, // 83 (10,3)
    {  5,  1, 77, 85, 33, 41,4294967295u,4294967295u}, // 84 (11,2)
    { 12,  1, 85, 91, 34, 42,4294967295u,4294967295u}, // 85 (12,1)
    { 52,  0, 86, 92, 27, 34,4294967295u,4294967295u}, // 86 (13,0)
    {  0, 56, 28, 37, 87, 93,4294967295u,4294967295u}, // 87 (0,14)
    {  1, 13, 29, 38, 88, 94,4294967295u,4294967295u}, // 88 (1,13)
    {  1,  6, 38, 48, 80, 88,4294967295u,4294967295u}, // 89 (2,12)
    {  6,  1, 85, 91, 42, 51,4294967295u,4294967295u}, // 90 (12,2)
    { 13,  1, 91, 97, 34, 42,4294967295u,4294967295u}, // 91 (13,1)
    { 56,  0, 92, 98, 35, 43,4294967295u,4294967295u}, // 92 (14,0)
    {  0, 60, 28, 37, 93, 99,4294967295u,4294967295u}, // 93 (0,15)
    {  1, 14, 37, 47, 94,100,4294967295u,4294967295u}, // 94 (1,14)
    {  1,  6, 38, 48, 88, 94,4294967295u,4294967295u}, // 95 (2,13)
    {  6,  1, 91, 97, 42, 51,4294967295u,4294967295u}, // 96 (13,2)
    { 14,  1, 97,103, 43, 52,4294967295u,4294967295u}, // 97 (14,1)
    { 60,  0, 98,104, 35, 43,4294967295u,4294967295u}, // 98 (15,0)
    {  0, 64, 36, 46, 99,105,4294967295u,4294967295u}, // 99 (0,16)
    {  1, 15, 37, 47,100,106,4294967295u,4294967295u}, // 100 (1,15)
    {  1,  7, 47, 58, 94,100,4294967295u,4294967295u}, // 101 (2,14)
    {  7,  1, 97,103, 52, 59,4294967295u,4294967295u}, // 102 (14,2)
    { 15,  1,103,109, 43, 52,4294967295u,4294967295u}, // 103 (15,1)
    { 64,  0,104,110, 44, 53,4294967295u,4294967295u}, // 104 (16,0)
    {  0, 68, 36, 46,105,111,4294967295u,4294967295u}, // 105 (0,17)
    {  1, 16, 46, 57,106,112,4294967295u,4294967295u}, // 106 (1,16)
    {  1,  7, 47, 58,100,106,4294967295u,4294967295u}, // 107 (2,15)
    {  7,  1,103,109, 52, 59,4294967295u,4294967295u}, // 108 (15,2)
    { 16,  1,109,113, 53, 60,4294967295u,4294967295u}, // 109 (16,1)
    { 68,  0,110,114, 44, 53,4294967295u,4294967295u}, // 110 (17,0)
    {  0, 72, 45, 56,111,115,4294967295u,4294967295u}, // 111 (0,18)
    {  1, 17, 46, 57,112,116,4294967295u,4294967295u}, // 112 (1,17)
    { 17,  1,113,119, 53, 60,4294967295u,4294967295u}, // 113 (17,1)
    { 72,  0,114,120, 54, 61,4294967295u,4294967295u}, // 114 (18,0)
    {  0, 76, 45, 56,115,121,4294967295u,4294967295u}, // 115 (0,19)
    {  1, 18, 56, 65,116,122,4294967295u,4294967295u}, // 116 (1,18)
    {  1,  8, 57, 66,112,116,4294967295u,4294967295u}, // 117 (2,17)
    {  8,  1,113,119, 60, 67,4294967295u,4294967295u}, // 118 (17,2)
    { 18,  1,119,125, 61, 68,4294967295u,4294967295u}, // 119 (18,1)
    { 76,  0,120,126, 54, 61,4294967295u,4294967295u}, // 120 (19,0)
    {  0, 80, 55, 64,121,127,4294967295u,4294967295u}, // 121 (0,20)
    {  1, 19, 56, 65,122,128,4294967295u,4294967295u}, // 122 (1,19)
    {  1,  9, 65, 74,116,122,4294967295u,4294967295u}, // 123 (2,18)
    {  9,  1,119,125, 68, 75,4294967295u,4294967295u}, // 124 (18,2)
    { 19,  1,125,131, 61, 68,4294967295u,4294967295u}, // 125 (19,1)
    { 80,  0,126,132, 62, 69,4294967295u,4294967295u}, // 126 (20,0)
    {  0, 84, 55, 64,127,133,4294967295u,4294967295u}, // 127 (0,21)
    {  1, 20, 64, 73,128,134,4294967295u,4294967295u}, // 128 (1,20)
    {  1,  9, 65, 74,122,128,4294967295u,4294967295u}, // 129 (2,19)
    {  9,  1,125,131, 68, 75,4294967295u,4294967295u}, // 130 (19,2)
    { 20,  1,131,137, 69, 76,4294967295u,4294967295u}, // 131 (20,1)
    { 84,  0,132,138, 62, 69,4294967295u,4294967295u}, // 132 (21,0)
    {  0, 88, 63, 72,133,139,4294967295u,4294967295u}, // 133 (0,22)
    {  1, 21, 64, 73,134,140,4294967295u,4294967295u}, // 134 (1,21)
    {  1, 10, 73, 82,128,134,4294967295u,4294967295u}, // 135 (2,20)
    { 10,  1,131,137, 76, 83,4294967295u,4294967295u}, // 136 (20,2)
    { 21,  1,137,143, 69, 76,4294967295u,4294967295u}, // 137 (21,1)
    { 88,  0,138,144, 70, 77,4294967295u,4294967295u}, // 138 (22,0)
    {  0, 92, 63, 72,139,145,4294967295u,4294967295u}, // 139 (0,23)
    {  1, 22, 72, 81,140,146,4294967295u,4294967295u}, // 140 (1,22)
    {  1, 10, 73, 82,134,140,4294967295u,4294967295u}, // 141 (2,21)
    { 10,  1,137,143, 76, 83,4294967295u,4294967295u}, // 142 (21,2)
    { 22,  1,143,147, 77, 84,4294967295u,4294967295u}, // 143 (22,1)
    { 92,  0,144,148, 70, 77,4294967295u,4294967295u}, // 144 (23,0)
    {  0, 96, 71, 80,145,149,4294967295u,4294967295u}, // 145 (0,24)
    {  1, 23, 72, 81,146,150,4294967295u,4294967295u}, // 146 (1,23)
    { 23,  1,147,151, 77, 84,4294967295u,4294967295u}, // 147 (23,1)
    { 96,  0,148,152, 78, 85,4294967295u,4294967295u}, // 148 (24,0)
    {  0,100, 63, 72,149,153,4294967295u,4294967295u}, // 149 (0,25)
    {  1, 24, 80, 89,150,154,4294967295u,4294967295u}, // 150 (1,24)
    { 24,  1,151,155, 85, 90,4294967295u,4294967295u}, // 151 (24,1)
    {100,  0,152,156, 70, 77,4294967295u,4294967295u}, // 152 (25,0)
    {  0,104, 63, 72,153,157,4294967295u,4294967295u}, // 153 (0,26)
    {  1, 25, 72, 81,154,158,4294967295u,4294967295u}, // 154 (1,25)
    { 25,  1,155,159, 77, 84,4294967295u,4294967295u}, // 155 (25,1)
    {104,  0,156,160, 70, 77,4294967295u,4294967295u}, // 156 (26,0)
    {  0,108, 63, 72,157,161,4294967295u,4294967295u}, // 157 (0,27)
    {  1, 26, 72, 81,158,162,4294967295u,4294967295u}, // 158 (1,26)
    { 26,  1,159,163, 77, 84,4294967295u,4294967295u}, // 159 (26,1)
    {108,  0,160,164, 70, 77,4294967295u,4294967295u}, // 160 (27,0)
    {  0,112, 63, 72,161,165,4294967295u,4294967295u}, // 161 (0,28)
    {  1, 27, 72, 81,162,166,4294967295u,4294967295u}, // 162 (1,27)
    { 27,  1,163,167, 77, 84,4294967295u,4294967295u}, // 163 (27,1)
    {112,  0,164,168, 70, 77,4294967295u,4294967295u}, // 164 (28,0)
    {  0,116, 63, 72,165,169,4294967295u,4294967295u}, // 165 (0,29)
    {  1, 28, 72, 81,166,170,4294967295u,4294967295u}, // 166 (1,28)
    { 28,  1,167,171, 77, 84,4294967295u,4294967295u}, // 167 (28,1)
    {116,  0,168,172, 70, 77,4294967295u,4294967295u}, // 168 (29,0)
    {  0,120, 63, 72,169,173,4294967295u,4294967295u}, // 169 (0,30)
    {  1, 29, 72, 81,170,174,4294967295u,4294967295u}, // 170 (1,29)
    { 29,  1,171,175, 77, 84,4294967295u,4294967295u}, // 171 (29,1)
    {120,  0,172,176, 70, 77,4294967295u,4294967295u}, // 172 (30,0)
    {  0,124, 63, 72,173,177,4294967295u,4294967295u}, // 173 (0,31)
    {  1, 30, 72, 81,174,178,4294967295u,4294967295u}, // 174 (1,30)
    { 30,  1,175,179, 77, 84,4294967295u,4294967295u}, // 175 (30,1)
    {124,  0,176,180, 70, 77,4294967295u,4294967295u}, // 176 (31,0)
    {  0,128, 63, 72,177,181,4294967295u,4294967295u}, // 177 (0,32)
    {  1, 31, 72, 81,178,182,4294967295u,4294967295u}, // 178 (1,31)
    { 31,  1,179,183, 77, 84,4294967295u,4294967295u}, // 179 (31,1)
    {128,  0,180,184, 70, 77,4294967295u,4294967295u}, // 180 (32,0)
    {  0,132, 63, 72,181,185,4294967295u,4294967295u}, // 181 (0,33)
    {  1, 32, 72, 81,182,186,4294967295u,4294967295u}, // 182 (1,32)
    { 32,  1,183,187, 77, 84,4294967295u,4294967295u}, // 183 (32,1)
    {132,  0,184,188, 70, 77,4294967295u,4294967295u}, // 184 (33,0)
    {  0,136, 63, 72,185,189,4294967295u,4294967295u}, // 185 (0,34)
    {  1, 33, 72, 81,186,190,4294967295u,4294967295u}, // 186 (1,33)
    { 33,  1,187,191, 77, 84,4294967295u,4294967295u}, // 187 (33,1)
    {136,  0,188,192, 70, 77,4294967295u,4294967295u}, // 188 (34,0)
    {  0,140, 63, 72,189,193,4294967295u,4294967295u}, // 189 (0,35)
    {  1, 34, 72, 81,190,194,4294967295u,4294967295u}, // 190 (1,34)
    { 34,  1,191,195, 77, 84,4294967295u,4294967295u}, // 191 (34,1)
    {140,  0,192,196, 70, 77,4294967295u,4294967295u}, // 192 (35,0)
    {  0,144, 71, 80,193,197,4294967295u,4294967295u}, // 193 (0,36)
    {  1, 35, 72, 81,194,198,4294967295u,4294967295u}, // 194 (1,35)
    { 35,  1,195,199, 77, 84,4294967295u,4294967295u}, // 195 (35,1)
    {144,  0,196,200, 78, 85,4294967295u,4294967295u}, // 196 (36,0)
    {  0,148, 71, 80,197,201,4294967295u,4294967295u}, // 197 (0,37)
    {  1, 36, 80, 89,198,202,4294967295u,4294967295u}, // 198 (1,36)
    { 36,  1,199,203, 85, 90,4294967295u,4294967295u}, // 199 (36,1)
    {148,  0,200,204, 78, 85,4294967295u,4294967295u}, // 200 (37,0)
    {  0,152, 71, 80,201,205,4294967295u,4294967295u}, // 201 (0,38)
    {  1, 37, 80, 89,202,206,4294967295u,4294967295u}, // 202 (1,37)
    { 37,  1,203,207, 85, 90,4294967295u,4294967295u}, // 203 (37,1)
    {152,  0,204,208, 78, 85,4294967295u,4294967295u}, // 204 (38,0)
    {  0,156, 71, 80,205,209,4294967295u,4294967295u}, // 205 (0,39)
    {  1, 38, 80, 89,206,210,4294967295u,4294967295u}, // 206 (1,38)
    { 38,  1,207,211, 85, 90,4294967295u,4294967295u}, // 207 (38,1)
    {156,  0,208,212, 78, 85,4294967295u,4294967295u}, // 208 (39,0)
    {  0,160, 71, 80,209,215,4294967295u,1073741823u}, // 209 (0,40)
    {  1, 39, 80, 89,210,213,4294967295u,4294967295u}, // 210 (1,39)
    { 39,  1,211,214, 85, 90,4294967295u,4294967295u}, // 211 (39,1)
    {160,  0,212,216, 78, 85,1073741823u,4294967295u}, // 212 (40,0)
    {  1, 40, 80, 89,213,217,4294967295u,1073741823u}, // 213 (1,40)
    { 40,  1,214,218, 85, 90,1073741823u,4294967295u}, // 214 (40,1)
    {  0,176, 71, 80,215,219,4294967295u,1073741823u}, // 215 (0,44)
    {176,  0,216,220, 78, 85,1073741823u,4294967295u}, // 216 (44,0)
    {  1, 44, 80, 89,217,221,4294967295u,1073741823u}, // 217 (1,44)
    { 44,  1,218,222, 85, 90,1073741823u,4294967295u}, // 218 (44,1)
    {  0,192, 71, 80,219,223,4294967295u, 536870911u}, // 219 (0,48)
    {192,  0,220,224, 78, 85, 536870911u,4294967295u}, // 220 (48,0)
    {  1, 48, 80, 89,221,225,4294967295u, 536870911u}, // 221 (1,48)
    { 48,  1,222,226, 85, 90, 536870911u,4294967295u}, // 222 (48,1)
    {  0,224, 79, 88,223,227,4294967295u, 536870911u}, // 223 (0,56)
    {224,  0,224,228, 86, 91, 536870911u,4294967295u}, // 224 (56,0)
    {  1, 56, 88, 95,225,229,4294967295u, 536870911u}, // 225 (1,56)
    { 56,  1,226,230, 91, 96, 536870911u,4294967295u}, // 226 (56,1)
    {  0,256, 87, 94,227,231,4294967295u, 134217727u}, // 227 (0,64)
    {256,  0,228,232, 92, 97, 134217727u,4294967295u}, // 228 (64,0)
    {  1, 64, 94,101,229,233,4294967295u, 134217727u}, // 229 (1,64)
    { 64,  1,230,234, 97,102, 134217727u,4294967295u}, // 230 (64,1)
    {  0,384, 93,100,231,235,4294967295u, 134217727u}, // 231 (0,96)
    {384,  0,232,236, 98,103, 134217727u,4294967295u}, // 232 (96,0)
    {  1, 96,100,107,233,237,4294967295u, 134217727u}, // 233 (1,96)
    { 96,  1,234,238,103,108, 134217727u,4294967295u}, // 234 (96,1)
    {  0,512,105,112,235,239,4294967295u, 134217727u}, // 235 (0,128)
    {512,  0,236,240,110,113, 134217727u,4294967295u}, // 236 (128,0)
    {  1,128,112,117,237,241,4294967295u, 134217727u}, // 237 (1,128)
    {128,  1,238,242,113,118, 134217727u,4294967295u}, // 238 (128,1)
    {  0,640,111,116,239,243,4294967295u, 134217727u}, // 239 (0,160)
    {640,  0,240,244,114,119, 134217727u,4294967295u}, // 240 (160,0)
    {  1,160,116,123,241,245,4294967295u, 134217727u}, // 241 (1,160)
    {160,  1,242,246,119,124, 134217727u,4294967295u}, // 242 (160,1)
    {  0,768,115,122,243,247,4294967295u, 134217727u}, // 243 (0,192)
    {768,  0,244,248,120,125, 134217727u,4294967295u}, // 244 (192,0)
    {  1,192,122,129,245,249,4294967295u, 134217727u}, // 245 (1,192)
    {192,  1,246,250,125,130, 134217727u,4294967295u}, // 246 (192,1)
    {  0,896,121,128,247,251,4294967295u, 138547332u}, // 247 (0,224)
    {896,  0,248,252,126,131, 138547332u,4294967295u}, // 248 (224,0)
    {  1,224,128,135,249,253,4294967295u, 138547332u}, // 249 (1,224)
    {224,  1,250,254,131,136, 138547332u,4294967295u}, // 250 (224,1)
    { 0,1020,127,134,251,251,4294967295u,         0u}, // 251 (0,255)
    {1020, 0,252,252,132,137,         0u,4294967295u}, // 252 (255,0)
    {  1,255,134,141,253,253,4294967295u,         0u}, // 253 (1,255)
    {255,  1,254,254,137,142,         0u,4294967295u}  // 254 (255,1)
};

//////////////////////////// ch ////////////////////////////

/* ch is a global object that provides common services to models.
It stores all the input so far in a rotating buffer of the last N bytes

  ch -- Global object
  ch.init() -- Initialize (after MEM is set)
  ch(i) -- Returns i'th byte from end
  ch(0) -- Returns the 0-7 bits of the partially read byte with a leading 1
  ch()  -- ch(0)
  ch.update(y) -- Appends bit y to the buffer
  ch.pos() -- The number of whole bytes appended, possibly > N
  ch.bpos() -- The number of bits (0-7) of the current partial byte at (0)
  ch[i] -- ch(pos()-i)
  ch.lo() -- Low order nibble so far (1-15 with leading 1)
  ch.hi() -- Previous nibble, 0-15 (no leading 1 bit)
  ch.pos(c) -- Position of the last occurrence of byte c (0-255)
  ch.pos(c, i) -- Position of the i'th to last occurrence, i = 0 to 3
*/
class Ch {
  U32 N;  // Buffer size
  U8 *buf;  // [N] last N bytes
  U32 p;  // pos()
  U32 bp;  // bpos()
  U32 hi_nibble, lo_nibble;  // hi(), lo()
  U32 lpos[256][4];  // pos(c, i)
public:
  Ch(): N(0), buf(0), p(0), bp(0), hi_nibble(0), lo_nibble(1) {
    memset(lpos, 0, 256*4*sizeof(U32));
  }
  void init() {
    N = 1 << (19+MEM-(MEM>=6));
    buf=(U8*)calloc(N, 1);
    //if (!buf)
      //handler();
    buf[0]=1;
  }
  U32 operator()(int i) const {return buf[(p-i)&(N-1)];}
  U32 operator()() const {return buf[p&(N-1)];}
  void update(int y) {
    U8& r=buf[p&(N-1)];
    r+=r+y;
    if (++bp==8) {
      lpos[r][3]=lpos[r][2];
      lpos[r][2]=lpos[r][1];
      lpos[r][1]=lpos[r][0];
      lpos[r][0]=p;
      bp=0;
      ++p;
      buf[p&(N-1)]=1;
    }
    if ((lo_nibble+=lo_nibble+y)>=16) {
      hi_nibble=lo_nibble-16;
      lo_nibble=1;
    }
  }
  U32 pos() const {return p;}
  U32 pos(U8 c, int i=0) const {return lpos[c][i&3];}
  U32 bpos() const {return bp;}
  U32 operator[](int i) const {return buf[i&(N-1)];}
  U32 hi() const {return hi_nibble;}
  U32 lo() const {return lo_nibble;}
} ch;  // Global object

//////////////////////////// Hashtable ////////////////////////////

/* A Hashtable stores Counters.  It is organized to minimize cache
misses for 64-byte cache lines.  The size is fixed at 2^n bytes.  It
uses LRU replacement for buckets of size 4, except that the next to
oldest element is replaced if it has lower priority than the oldest.
Each bucket represents 15 counters for a context on a half-byte boundary.

  Hashtable<Counter> ht(n) -- Create hash table of 2^n bytes (15/16 of
    these are 1-byte Counters).
  ht.set(h) -- Set major context to h, a 32 bit hash of a context ending on a
    nibble (4-bit) boundary.
  ht(c) -- Retrieve a reference to counter associated with partial nibble c
    (1-15) in context h.

Normally there should be 4 calls to ht(c) after each ht.set(h).
*/

template<class T>
class Hashtable {
private:
  const U32 N;  // log2 size in bytes
  struct HashElement {
    U8 checksum;  // Checksum of context, used to detect collisions
    T c[15];  // 1-byte counters in minor context c
    HashElement(): checksum(0) {}
  };
  HashElement *table;  // [2^(N-4)]
  U32 cxt;  // major context
public:
  Hashtable(U32 n);

  // Set major context to h, a 32 bit hash.  Create a new element if needed.
  void set(U32 h) {

    // Search 4 elements for h within a 64-byte cache line
    const U8 checksum=(h>>24)^h;
    const U32 lo= (h>>(32-N)) & -4;
    const U32 hi=lo+4;
    U32 i;
    for (i=lo; i<hi; ++i) {
      U32 pri=table[i].c[0].priority();
      if (table[i].checksum==checksum) { // found
        cxt=i;
        break;
      }
      else if (pri==0) {  // empty bucket
        table[i].checksum=checksum;
        cxt=i;
        break;
      }
    }

    // Put new element in front, pushing the lower priority of the two
    // oldest off the back
    if (i==hi) {
      cxt=lo;
      if (table[lo+2].c[0].priority()<table[lo+3].c[0].priority())
        memmove(table+lo+1, table+lo, 32);
      else
        memmove(table+lo+1, table+lo, 48);
      memset(table+lo, 0, 16);
      table[cxt].checksum=checksum;
    }

    // Move newest to front
    else if (cxt!=lo) {
      HashElement he=table[cxt];
      memmove(table+lo+1, table+lo, (cxt-lo)*16);
      table[lo]=he;
      cxt=lo;
    }
  }

  // Get element c (1-15) of bucket cxt
  T& operator()(U32 c) {
    --c;
    assert(c<15);
    return table[cxt].c[c];
  }
};

template <class T>
Hashtable<T>::Hashtable(U32 n): N(n>4?n-4:1), table(0), cxt(0) {
  assert(sizeof(HashElement)==16);
  assert(sizeof(char)==1);

  // Align the hash table on a 64 byte cache page boundary
  char *p=(char*)calloc((16<<N)+64, 1);
  //if (!p)
    //handler();
  p+=64-(((int)p)&63);  // Aligned
  table=(HashElement*)p;
}

//////////////////////////// mixer ////////////////////////////

/* A Mixer combines a weighted set of probabilities (expressed as 0 and
1 counts) into a single probability P(1) that the next bit will be a 1.

  Mixer m(C);      -- Create Mixer with C sets of N weights (N is fixed)
  m.write(n0, n1); -- Store a prediction P(1) = n1/(n0+n1), with confidence
                      0 <= n0+n1 < 1024.  There should be at most N calls
                      to write() followed by predict() and update().
                      Write order should be consistent.
  m.add(n0, n1);   -- Adds to a previous write.
  m.predict(c);    -- Return P(1)*PSCALE (range 0 to PSCALE-1) for
                      weight set c (0 to C-1).
  m.update(y);     -- Tune the N internal weights for set c such that
                      predict(c) would return a result closer to y*PSCALE,
                      y = 0 or 1.
*/
class Mixer {
  enum {N=64};  // Max writes before update
  const int C;
  U32 *bc0, *bc1;  // 0,1 counts for N models
  U32 (*wt)[N];  // wt[c][n] is n'th weight in context c
  int n;  // number of bit count pairs written
  int c;  // weight set context
public:
  Mixer(int C_);
  ~Mixer();
  U32 getN() const {return N;}
  U32 getC() const {return C;}

  // Store next counts n0, n1 from model
  void write(int n0, int n1) {
    bc0[n]=n0;
    bc1[n]=n1;
    ++n;
  }

  // Add to the last write
  void add(int n0, int n1) {
    bc0[n-1]+=n0;
    bc1[n-1]+=n1;
  }
  int predict(int c_);
  void update(int y);
};

// Return weighted average of models in context c_
int Mixer::predict(int c_) {
  assert(n>0 && n<=N);
  assert(c_>=0 && c_<C);
  c=c_;
  int n0=1, n1=n0;
  for (int j=0; j<n; ++j) {
    U32 w=wt[c][j];
    n0+=bc0[j]*w;
    n1+=bc1[j]*w;
  }
  int sum=n0+n1;
  while (sum>2000000000/PSCALE) sum/=4, n1/=4;
  assert(sum>0);
  return (PSCALE-1)*n1/sum;
}

// Adjust the weights by gradient descent to reduce cost of bit y
void Mixer::update(int y) {
  U32 s0=0, s1=0;
  for (int i=0; i<n; ++i) {
    s0+=(wt[c][i]+48)*bc0[i];
    s1+=(wt[c][i]+48)*bc1[i];
  }
  if (s0>0 && s1>0) {
    const U32 s=s0+s1;
    const U32 sy=y?s1:s0;
    const U32 sy1=((0xffffffff/sy)+(rnd()&1023)) >> 10;
    const U32 s1 =((0xffffffff/s) +(rnd()&1023)) >> 10;
    for (int i=0; i<n; ++i) {
      const int dw=int((y?bc1[i]:bc0[i])*sy1-(bc0[i]+bc1[i])*s1
         + (rnd()&255)) >> 8;
      wt[c][i]=min(65535, max(1, int(wt[c][i]+dw)));
    }
  }
  n=0;
}

Mixer::Mixer(int C_): C(C_), bc0(new U32[N]), bc1(new U32[N]),
                      wt(new U32[C_][N]), n(0), c(0) {
  for (int i=0; i<C; ++i) {
    for (int j=0; j<N; ++j)
      wt[i][j]=1;
  }
  for (int i=0; i<N; ++i)
    bc0[i]=bc1[i]=0;
}

Mixer::~Mixer() {
/*
  // Uncomment this to print the weights.  This is useful for testing
  // new models or weight vector contexts.
  if (n==0)
    return;
  printf("  ");
  for (int i=0; i<n; ++i)
    printf("%4d", i);
  printf("\n");
  fflush(stdout);
  for (int i=0; i<C && i<16; ++i) {
    printf("%2d", i);
    for (int j=0; j<n; ++j)
      printf("%4d", wt[i][j]/10);
    printf("\n");
    fflush(stdout);
  } */
}

// A MultiMixer averages the output of 2 mixers using different contexts
class MultiMixer {
  enum {MINMEM=5};  // Lowest MEM to use 2 mixers
  Mixer m1, m2;
public:
  MultiMixer(): m1(16), m2(16) {}
  void write(int n0, int n1) {
    m1.write(n0, n1);
    if (MEM>=MINMEM)
      m2.write(n0, n1);
  }
  void add(int n0, int n1) {
    if (MEM>=MINMEM) {
      m1.add(n0, n1);
      m2.add(n0, n1);
    }
    else
      m1.add(n0, n1);
  }
  int predict() {
    U32 p1=m1.predict((ch(1) >> 5) + 8*(ch.pos(0, 3) < ch.pos(32, 3)));
    if (MEM>=MINMEM) {
      U32 p2=m2.predict((ch(1) >> 6)+4*(ch(2) >> 6));
      return (p1+p2)/2;
    }
    else
      return p1;
  }
  void update(int y) {
    m1.update(y);
      if (MEM>=MINMEM)
    m2.update(y);
  }
  U32 getC() const {return 256;}
  U32 getN() const {return m1.getN();}
};

MultiMixer mixer;

//////////////////////////// CounterMap ////////////////////////////

/* CounterMap maintains a model and one context

  Countermap cm(N); -- Create, size 2^N bytes
  cm.update(h);     -- Update model, then set next context hash to h
  cm.write();       -- Predict next bit and write counts to mixer
  cm.add();         -- Predict and add to previously written counts

There should be 8 calls to either write() or add() between each update(h).
h is a 32-bit hash of the context which should be set after a whole number
of bytes are read. */

// Stores only the most recent byte and its count per context (run length)
// in a hash table without collision detection
class CounterMap1 {
  const int N;
  struct S {
    U8 c;  // char
    U8 n;  // count
  };
  S* t;  // cxt -> c repeated last n times
  U32 cxt;
public:
  CounterMap1(int n): N(n>1?n-1:1), cxt(0) {
    assert(sizeof(S)==2);
    t=(S*)calloc(1<<N, 2);
    //if (!t)
      //handler();
  }
  void update(U32 h) {
    if (ch.bpos()==0) {
      if (t[cxt].n==0) {
        t[cxt].n=1;
        t[cxt].c=ch(1);
      }
      else if (U32(t[cxt].c)==ch(1)) {
        if (t[cxt].n<255)
          ++t[cxt].n;
      }
      else {
        t[cxt].c=ch(1);
        t[cxt].n=1;
      }
    }
    cxt = h >> (32-N);
  }
  void add() {
    if ((U32)((t[cxt].c+256) >> (8-ch.bpos()))==ch()) {
      if ((t[cxt].c >> (7-ch.bpos())) & 1)
        mixer.add(0, t[cxt].n);
      else
        mixer.add(t[cxt].n, 0);
    }
  }
  void write() {
    mixer.write(0, 0);
    add();
  }
};

// Uses a nibble-oriented hash table of contexts (counter state)
class CounterMap2 {
private:
  const U32 N2;  // Size of ht2 in elements
  U32 cxt;  // Major context
  Hashtable<Counter> ht2;  // Secondary hash table
  Counter* cp[8];  // Pointers into ht2 or 0 if not used
public:
  CounterMap2(int n);  // Use 2^n bytes memory
  void add();
  void update(U32 h);
  void write() {
    mixer.write(0, 0);
    add();
  }
};

CounterMap2::CounterMap2(int n): N2(n), cxt(0), ht2(N2) {
  for (int i=0; i<8; ++i)
    cp[i]=0;
}

// Predict the next bit given the bits so far in ch()
void CounterMap2::add() {
  const U32 bcount = ch.bpos();
  if (bcount==4) {
    cxt^=hash(ch.hi(), cxt);
    ht2.set(cxt);
  }
  cp[bcount]=&ht2(ch.lo());
  mixer.add(cp[bcount]->get0(), cp[bcount]->get1());
}

// After 8 predictions, update the models with the last input char, ch(1),
// then set the new context hash to h
void CounterMap2::update(U32 h) {
  const U32 c=ch(1);

  // Update the secondary context
  for (int i=0; i<8; ++i) {
    if (cp[i]) {
      cp[i]->add((c>>(7-i))&1);
      cp[i]=0;
    }
  }
  cxt=h;
  ht2.set(cxt);
}

// Combines 1 and 2 above.
class CounterMap3 {
  enum {MINMEM=5};  // Smallest MEM to use cm1
  CounterMap1 cm1;
  CounterMap2 cm2;
public:
  CounterMap3(int n): cm1(MEM>=MINMEM ? n-2 : 0), cm2(n) {}
  void update(U32 h) {
    if (MEM>=MINMEM)
      cm1.update(h);
    cm2.update(h);
  }
  void write() {
    cm2.write();
    if (MEM>=MINMEM)
      cm1.add();
  }
  void add() {
    cm2.add();
    if (MEM>=MINMEM)
      cm1.add();
  }
};

#define CounterMap CounterMap3

//////////////////////////// Model ////////////////////////////

// All models have a function model() which updates the model with the
// last bit of input (in ch) then writes probabilities for the following
// bit into mixer.
class Model {
public:
  virtual void model() = 0;
  virtual ~Model() {}
};

//////////////////////////// defaultModel ////////////////////////////

// DefaultModel predicts P(1) = 0.5

class DefaultModel: public Model {
public:
  void model() {mixer.write(1, 1);}
};

//////////////////////////// charModel ////////////////////////////

// A CharModel contains n-gram models from 0 to 9

class CharModel: public Model {
  enum {N=10};        // Number of models
  Counter *t0, *t1;   // Model orders 0, 1 [256], [65536]
  CounterMap t2, t3, t4, t5, t6, t7, t8, t9;  // Model orders 2-9
  U32 *cxt;           // Context hashes [N]
  Counter *cp0, *cp1; // Pointers to counters in t0, t1
public:
  CharModel(): t0(new Counter[256]), t1(new Counter[65536]),	
               t2(MEM+15), t3(MEM+17), t4(MEM+18), t5((MEM>=1)*(MEM+18)),
               t6((MEM>=3)*(MEM+18)), t7((MEM>=3)*(MEM+18)),
               t8((MEM>=5)*(MEM+18-(MEM>=6))),
               t9((MEM>=5)*(MEM+18-(MEM>=6))),
               cxt(new U32[N]) {
    cp0=&t0[0];
    cp1=&t1[0];
    memset(cxt, 0, N*sizeof(U32));
    memset(t0, 0, 256*sizeof(Counter));
    memset(t1, 0, 65536*sizeof(Counter));
  }
  void model();         // Update and predict
};

// Update with bit y, put array of 0 counts in n0 and 1 counts in n1
inline void CharModel::model() {

  // Update models
  int y = ch(ch.bpos()==0)&1;  // last input bit
  cp0->add(y);
  cp1->add(y);

  // Update context
  if (ch.bpos()==0) {  // Start new byte
    for (int i=N-1; i>0; --i)
      cxt[i]=cxt[i-1]^hash(ch(1), i);
    t2.update(cxt[2]);
    t3.update(cxt[3]);
    t4.update(cxt[4]);
    if (MEM>=1)
      t5.update(cxt[5]);
    if (MEM>=3) {
      t6.update(cxt[6]);
      t7.update(cxt[7]);
    }
    if (MEM>=5) {
      t8.update(cxt[8]);
      t9.update(cxt[9]);
    }
  }
  cp0=&t0[ch()];
  cp1=&t1[ch()+256*ch(1)];

  // Write predictions to the mixer
  mixer.write(cp0->get0(), cp0->get1());
  mixer.write(cp1->get0(), cp1->get1());
  t2.write();
  t3.write();
  t4.write();
  if (MEM>=1)
    t5.add();
  if (MEM>=3) {
    t6.write();
    t7.add();
  }
  if (MEM>=5) {
    t8.write();
    t9.add();
  }
}

//////////////////////////// matchModel ////////////////////////////

/* A MatchModel looks for a match of length n >= 8 bytes between
the current context and previous input, and predicts the next bit
in the previous context with weight n.  If the next bit is 1, then
the mixer is assigned (0, n), else (n, 0).  Matchies are found using
an index (a hash table of pointers into ch). */

class MatchModel: public Model {
  const int N;      // 2^N = hash table size
  enum {M=4};       // Number of strings to match
  U32 hash[2];      // Hashes of current context up to pos-1
  U32 begin[M];     // Points to first matching byte
  U32 end[M];       // Points to last matching byte + 1, 0 if no match
  U32 *ptr;         // Hash table of pointers [2^(MEM+17)]
public:
  MatchModel(): N(17+MEM-(MEM>=6)), ptr(new U32[1 << N]) {
    memset(ptr, 0, (1 << N)*sizeof(U32));                             
    hash[0]=hash[1]=0;
    for (int i=0; i<M; ++i)
      begin[i]=end[i]=0;
  }
  void model();
};

inline void MatchModel::model() {
  if (ch.bpos()==0) {  // New byte
    hash[0]=hash[0]*(16*56797157)+ch(1)+1;  // Hash last 8 bytes
    hash[1]=hash[1]*(2*45684217)+ch(1)+1;   // Hash last 32 bytes
    U32 h=hash[0] >> (32-N);
    if ((hash[0]>>28)==0)
      h=hash[1] >> (32-N);  // 1/16 of 8-contexts are hashed to 32 bytes   
    for (int i=0; i<M; ++i) {
      if (end[i] && ch(1)==ch[end[i]])
        ++end[i];
    }
    for (int i=0; i<M; ++i) {
      if (!end[i]) { // Search for a matching context
        int j;
        for (j=0; j<M; ++j)  // Search for duplicate match
          if (ptr[h]==end[j])
            break;
        if (j!=M)  // Context already matched?
          break;
        end[i]=ptr[h];
        if (end[i]>0) {
          begin[i]=end[i];
          U32 p=ch.pos();
          while (begin[i]>0 && p>0 && begin[i]!=p+1
              && ch[begin[i]-1]==ch[p-1]) {
            --begin[i];
            --p;
          }
        }
        if (end[i]==begin[i])  // No match found
          begin[i]=end[i]=0;
        break;
      }
    }
    ptr[h]=ch.pos();
  }

  // Test whether the current context is valid in the last 0-7 bits
  for (int i=0; i<M; ++i) {
    if (end[i] && ((ch[end[i]]+256) >> (8-ch.bpos())) != ch())
      begin[i]=end[i]=0;
  }

  // Predict the bit found in the matching contexts
  int n0=0, n1=0;
  for (int i=0; i<M; ++i) {
    if (end[i]) { 
      U32 wt=(end[i]-begin[i]);
      wt=wt*wt/4;
      if (wt>511)
        wt=511;
      int y=(ch[end[i]]>>(7-ch.bpos()))&1;
      if (y)
        n1+=wt;
      else
        n0+=wt;
    }
  }
  mixer.write(n0, n1);
}

//////////////////////////// recordModel ////////////////////////////

/* A RecordModel finds fixed length records and models bits in the context
of the two bytes above (the same position in the two previous records)
and in the context of the byte above and to the left (the previous byte).
The record length is assumed to be the interval in the most recent
occurrence of a byte occuring 4 times in a row equally spaced, e.g.
"x..x..x..x" would imply a record size of 3.  There are models for
the 2 most recent, different record lengths of at least 2. */

class RecordModel: public Model {
  const int SIZE;
  enum {N=2};           // Number of models
  CounterMap t0, t1, t2, t3, t4;  // Model
  int repeat1, repeat2;  // 2 last cycle lengths
public:
  RecordModel(): SIZE((MEM>=4)*(16+MEM-(MEM>=6))),
                 t0(SIZE), t1(SIZE), t2(SIZE), t3(SIZE), t4(SIZE),
                 repeat1(2), repeat2(3) {}
  void model(); 
};

// Update the model with bit y, then put predictions of the next update
// as 0 counts in n0[0..N-1] and 1 counts in n1[0..N-1]
inline void RecordModel::model() {
  if (ch.bpos()==0) {

    // Check for a repeating pattern of interval 3 or more
    const int c=ch(1);
    const int d1=ch.pos(c,0)-ch.pos(c,1);
    const int d2=ch.pos(c,1)-ch.pos(c,2);
    const int d3=ch.pos(c,2)-ch.pos(c,3);
    if (d1>1 && d1==d2 && d2==d3) {
      if (d1==repeat1)
        swap(repeat1, repeat2);
      else if (d1!=repeat2) {
        repeat1=repeat2;
        repeat2=d1;
      }
    }

    // Compute context hashes
    int r1=repeat1, r2=repeat2;
    if (r1>r2)
      swap(r1, r2);
    t0.update(hash(ch(r1), ch(r1*2), r1));  // 2 above (shorter repeat)
    t1.update(hash(ch(1), ch(r1), r1));     // above and left
    t2.update(hash(ch(r1), ch.pos()%r1));   // above and pos
    t3.update(hash(ch(r2), ch(r2*2), r2));  // 2 above (longer repeat)
    t4.update(hash(ch(1), ch(r2), r2));     // above and left
  }
  t0.write();
  t1.write();
  t2.write();
  t3.write();
  t4.write();
}

//////////////////////////// sparseModel ////////////////////////////

// A SparseModel models several order-2 contexts with gaps

class SparseModel: public Model {
  const int SIZE;
  enum {N=10};   // Number of models
  CounterMap t0, t1, t2, t3, t4, t5, t6, t7, t8;  // Sparse models
public:
  SparseModel(): SIZE((MEM>=4)*(MEM+15-(MEM>=6))),
                 t0(SIZE), t1(SIZE), t2(SIZE), t3(SIZE), t4(SIZE),
                 t5(SIZE), t6(SIZE), t7(SIZE), t8(SIZE) {}
  void model();  // Update and predict
};

inline void SparseModel::model() {

  // Update context
  if (ch.bpos()==0) {
    t0.update(hash(ch(1), ch(3)));
    t1.update(hash(ch(1), ch(4)));
    t2.update(hash(ch(1), ch(5)));
    t3.update(hash(ch(1), ch(6)));
    t4.update(hash(ch(2), ch(3)));
    t5.update(hash(ch(2), ch(4)));
    t6.update(hash(ch(3), ch(4)));
    const int g=min(255, int(ch.pos()-ch.pos(ch(1), 2))); // gap to prior ch1
    t7.update(hash(ch(1), g));
    t8.update(hash(ch(1), ch(2), g));
  }

  // Predict

  t0.write();
  t1.write();
  t2.write();
  t3.write();
  t4.write();
  t5.write();
  t6.write();
  t7.write();
  t8.write();
}

//////////////////////////// analogModel ////////////////////////////

// An AnalogModel is intended for 16-bit mono or stereo (WAV files)
// 24-bit images (BMP files), and 8 bit analog data (such as grayscale
// images), and CCITT images.

class AnalogModel: public Model {
  const int SIZE;
  enum {N=6};
  CounterMap t0, t1, t2, t3, t4, t5, t6;
  int pos3;  // pos % 3
public:
  AnalogModel(): SIZE((MEM>=4)*(MEM+13)), t0(SIZE), t1(SIZE),
                 t2(SIZE), t3(SIZE), t4(SIZE), t5(SIZE), t6(SIZE), pos3(0) {}
  void model() {
    if (ch.bpos()==0) {
      if (++pos3==3) pos3=0;
      t0.update(hash(ch(2)/4, ch(4)/4, ch.pos()%2));  // 16 bit mono model
      t1.update(hash(ch(2)/16, ch(4)/16, ch.pos()%2));
      t2.update(hash(ch(2)/4, ch(4)/4, ch(8)/4, ch.pos()%4)); // Stereo
      t3.update(hash(ch(3), ch(6)/4, pos3));  // 24 bit image models
      t4.update(hash(ch(1)/16, ch(2)/16, ch(3)/4, pos3)); 
      t5.update(hash(ch(1)/2, ch(2)/8, ch(3)/32));  // 8-bit data model
      t6.update(hash(ch(216), ch(432)));  // CCITT images
    }
    t0.write();
    t1.add();
    t2.add();
    t3.write();
    t4.add();
    t5.write();
    t6.write();
  }
};

//////////////////////////// wordModel ////////////////////////////

// A WordModel models words, which are any characters > 32 separated
// by whitespace ( <= 32).  There is a unigram, bigram and sparse
// bigram model (skipping 1 word).

class WordModel: public Model {
  const int SIZE;
  enum {N=3};
  CounterMap t0, t1, t2, t3, t4, t5;
  U32 cxt[N];   // Hashes of last N words broken on whitespace
  U32 word[N];  // Hashes of last N words of letters only, lower case
public:
  WordModel(): SIZE((MEM>=4)*(MEM+17-(MEM>=6))),
               t0(SIZE), t1(SIZE), t2(SIZE), t3(SIZE), t4(SIZE), t5(SIZE) {
    for (int i=0; i<N; ++i)
      cxt[i]=word[i]=0;
  }
  void model() {
    if (ch.bpos()==0) {
      int c=ch(1);
      if (c>32) {
        cxt[0]^=hash(cxt[0], c);
      }
      else if (cxt[0]) {
        for (int i=N-1; i>0; --i)
          cxt[i]=cxt[i-1];
        cxt[0]=0;
      }
      if (isalpha(c) || c>=192) 
        word[0]^=hash(word[0], tolower(c), 1);
      else {
        for (int i=N-1; i>0; --i)
          word[i]=word[i-1];
        word[0]=0;
      }
      t0.update(cxt[0]);
      t1.update(cxt[1]+cxt[0]);
      t2.update(cxt[2]+cxt[0]);
      t3.update(word[0]);
      t4.update(word[1]+word[0]);
      t5.update(word[2]+word[0]);
    }
    t0.write();
    t1.write();
    t2.write();
    t3.write();
    t4.write();
    t5.write();
  }
};

//////////////////////////// exeModel ////////////////////////////

// Model 32-bit Intel executables, changing relative call (E8) operands
// to absolute addresses

class ExeModel {
  struct S {
    U32 a;  // absolute address, indexed on 8 low order bytes
    U8 n;  // how many times?
    S(): a(0), n(0) {}
  };
  S t[256];  // E8 history indexed on low order byte
public:
  void model() {

    // Convert E8 relative little-endian address to absolute by adding
    // file offset, then store in table t indexed by its low byte
    if (ch.bpos()==0) {
      if (ch(5)==0xe8 && (ch(1)==0 || ch(1)==0xff)) {
        U32 a=ch(4)+(ch(3)<<8)+(ch(2)<<16)+(ch(1)<<24)+ch.pos()-5;
        int i=a&0xff;
        if (t[i].a==a && t[i].n<255)
          ++t[i].n;
        else {
          t[i].a=a;
          t[i].n=1;
        }
      }
    }
    int n0=0, n1=0;

    // Model 4th byte of address
    if (ch(4)==0xe8) {
      int i=(ch(3)+ch.pos()-4)&0xff;  // index in t
      if (t[i].n>0) {
        U32 r=t[i].a-ch.pos()+4;  // predicted relative address
        U32 ck=(((r&0xff000000)>>8)+0x1000000)>>(24-ch.bpos());
          // ch(0) should be this if context matches so far
        int y=(r>>(31-ch.bpos()))&1;  // predicted bit
        if (ch(0)==ck && ch(1)==((r>>16)&0xff)) {
          if (y)
            n1=t[i].n*16;
          else
            n0=t[i].n*16;
        }
      }
    }

    // Model 3rd byte of address
    if (ch(3)==0xe8) {
      int i=(ch(2)+ch.pos()-3)&0xff;
      if (t[i].n>0) {
        U32 r=t[i].a-ch.pos()+3;
        U32 ck=((r&0xff0000)+0x1000000)>>(24-ch.bpos());
        int y=(r>>(23-ch.bpos()))&1;
        if (ch(0)==ck && ch(1)==((r>>8)&0xff)) {
          if (y)
            n1=t[i].n*4;
          else
            n0=t[i].n*4;
        }
      }
    }

    // Model 2nd byte of address
    else if (ch(2)==0xe8) {
      int i=(ch(1)+ch.pos()-2)&0xff;
      if (t[i].n>0) {
        U32 r=t[i].a-ch.pos()+2;
        U32 ck=((r&0xff00)+0x10000)>>(16-ch.bpos());
        int y=(r>>(15-ch.bpos()))&1;
        if (ch(0)==ck) {
          if (y)
            n1=t[i].n;
          else
            n0=t[i].n;
        }
      }
    }
    mixer.write(n0, n1);
  }
};

//////////////////////////// Predictor ////////////////////////////

/* A Predictor adjusts the model probability using SSE and passes it
to the encoder.  An SSE model is a table of counters, sse[SSE1][SSE2]
which maps a context and a probability into a new, more accurate
probability.  The context, SSE1, consists of the 0-7 bits of the current
byte and the 2 leading bits of the previous byte.  The probability
to be mapped, SSE2 is first stretched near 0 and 1 using SSEMap, then
quantized into SSE2=32 intervals.  Each SSE element is a pair of 0
and 1 counters of the bits seen so far in the current context and
probability range.  Both the bin below and above the current probability
is updated by adding 1 to the appropriate count (n0 or n1).  The
output probability for an SSE element is n1/(n0+n1) interpolated between
the bins below and above the input probability.  This is averaged
with the original probability with 25% weight to give the final
probability passed to the encoder. */

class Predictor {

  // Models
  DefaultModel defaultModel;
  CharModel charModel;
  MatchModel matchModel;
  RecordModel recordModel;
  SparseModel sparseModel;
  AnalogModel analogModel;
  WordModel wordModel;
  ExeModel exeModel;

  enum {SSE1=256*4*2, SSE2=32,  // SSE dimensions (contexts, probability bins)
    SSESCALE=1024/SSE2};      // Number of mapped probabilities between bins

  // Scale probability p into a context in the range 0 to 1K-1 by
  // stretching the ends of the range.
  class SSEMap {
    U16 table[PSCALE];
  public:
    int operator()(int p) const {return table[p];}
    SSEMap();
  } ssemap;  // functoid

  // Secondary source encoder element
  struct SSEContext {
    U8 c1, n;  // Count of 1's, count of bits
    int p() const {return PSCALE*(c1*64+1)/(n*64+2);}
    void update(int y) {
      if (y)
        ++c1;
      if (++n>254) {  // Roll over count overflows
        c1/=2;
        n/=2;
      }
    }
    SSEContext(): c1(0), n(0) {}
  };

  SSEContext (*sse)[SSE2+1];  // [SSE1][SSE2+1] context, mapped probability
  U32 nextp;   // p()
  U32 ssep;    // Output of sse
  U32 context; // SSE context
public:
  Predictor();
  int p() const {return nextp;}  // Returns pr(y = 1) * PSCALE
  void update(int y);  // Update model with bit y = 0 or 1
};

Predictor::SSEMap::SSEMap() {
  for (int i=0; i<PSCALE; ++i) {
    int p=int(64*log((i+0.5)/(PSCALE-0.5-i))+512);
    if (p>1023) p=1023;
    if (p<0) p=0;
    table[i]=p;
  }
}

Predictor::Predictor(): sse(0), nextp(PSCALE/2), ssep(512), context(0) {
  ch.init();

  // Initialize to sse[context][ssemap(p)] = p
  if (MEM>=1) {
    sse=(SSEContext(*)[SSE2+1]) new SSEContext[SSE1][SSE2+1];
    int N=PSCALE;
    int oldp=SSE2+1;
    for (int i=N-1; i>=0; --i) {
      int p=(ssemap(i*PSCALE/N)+SSESCALE/2)/SSESCALE;
      int n=1+N*N/((i+1)*(N-i));
      if (n>254) n=254;
      int c1=(i*n+N/2)/N;
      for (int j=oldp-1; j>=p; --j) {
        for (int k=0; k<SSE1; ++k) {
          sse[k][j].n=n;
          sse[k][j].c1=c1;
        }
      }
      oldp=p;
    }
  }
}

inline void Predictor::update(int y) {

  // Update the bins below and above the last input probability, ssep
  if (MEM>=1) {
    sse[context][ssep/SSESCALE].update(y);
    sse[context][ssep/SSESCALE+1].update(y);
  }

  // Adjust model mixing weights
  mixer.update(y);

  // Update individual models
  ch.update(y);
  defaultModel.model(); 
  charModel.model();
  if (MEM>=2)
    matchModel.model();
  if (MEM>=4) {
    recordModel.model();
    sparseModel.model();
    analogModel.model();
    wordModel.model();
  }
  if (MEM>=3)
    exeModel.model();

  // Combine probabilities
  nextp=mixer.predict();

  // Get final probability, interpolate SSE and average with original
  if (MEM>=1) {
    context=(ch(0)*4+ch(1)/64)*2+(ch.pos(0,3)<ch.pos(32,3));  // for SSE
    ssep=ssemap(nextp);
    U32 wt=ssep%SSESCALE;
    U32 i=ssep/SSESCALE;
    nextp=(((sse[context][i].p()*(SSESCALE-wt)+sse[context][i+1].p()*wt)
      /SSESCALE)*3+nextp)/4;
  }
}

//////////////////////////// Encoder ////////////////////////////

/* An Encoder does arithmetic encoding.  Methods:
   Encoder(COMPRESS, f) creates encoder for compression to archive f, which
     must be open past the header for writing in binary mode
   Encoder(DECOMPRESS, f) creates encoder for decompression from archive f,
     which must be open past the header for reading in binary mode
   encode(bit) in COMPRESS mode compresses bit to file f.
   decode() in DECOMPRESS mode returns the next decompressed bit from file f.
   flush() should be called when there is no more to compress
*/

typedef enum {COMPRESS, DECOMPRESS} Mode;
class Encoder {
private:
  Predictor predictor;
  const Mode mode;       // Compress or decompress?
  FILE* archive;         // Compressed data file
  U32 x1, x2;            // Range, initially [0, 1), scaled by 2^32
  U32 x;                 // Last 4 input bytes of archive.
public:
  Encoder(Mode m, FILE* f);
  //void encode(int y);    // Compress bit y
  int decode();          // Uncompress and return bit y
  //void flush();          // Call when done compressing
};

// Constructor
Encoder::Encoder(Mode m, FILE* f): predictor(), mode(m), archive(f), x1(0),
                                   x2(0xffffffff), x(0) {

  // In DECOMPRESS mode, initialize x to the first 4 bytes of the archive
  if (mode==DECOMPRESS) {
    for (int i=0; i<4; ++i) {
      int c=xgetc(archive);
      if (c==EOF) c=0;  // PAQ6v2 bug fix (thanks to Alexander Ratushnyak)
      x=(x<<8)+(c&0xff);
    }
  }
}

/* Decode one bit from the archive, splitting [x1, x2] as in the encoder
and returning 1 or 0 depending on which subrange the archive point x is in.
*/
inline int Encoder::decode() {

  // Split the range
  const U32 p=predictor.p()*(4096/PSCALE)+2048/PSCALE; // P(1) * 4K
  assert(p<4096);
  const U32 xdiff=x2-x1;
  U32 xmid=x1;  // = x1+p*(x2-x1) multiply without overflow, round down
  if (xdiff>=0x4000000) xmid+=(xdiff>>12)*p;
  else if (xdiff>=0x100000) xmid+=((xdiff>>6)*p)>>6;
  else xmid+=(xdiff*p)>>12;

  // Update the range
  int y=0;
  if (x<=xmid) {
    y=1;
    x2=xmid;
  }
  else
    x1=xmid+1;
  predictor.update(y);

  // Shift equal MSB's out
  while (((x1^x2)&0xff000000)==0) {
    x1<<=8;
    x2=(x2<<8)+255;
    int c=xgetc(archive);
    if (c==EOF) c=0;
    x=(x<<8)+c;
  }
  return y;
}

//////////////////////////// Transformer ////////////////////////////

/* A transformer compresses 1 byte at a time.  It also provides a
   place to insert transforms or filters in the future.

  Transformer tf(COMPRESS, f) -- Initialize for compression to archive f
    which must be open in "wb" mode with the header already written
  Transformer tf(DECOMPRESS, f) -- Initialize for decompression from f which
    must be open in "rb" mode past the header
  tf.encode(c) -- Compress byte c
  c = tf.decode() -- Decompress byte c
  tf.flush() -- Should be called when compression is finished
*/

class Transformer {
  Encoder e;
public:
  Transformer(Mode mode, FILE* f): e(mode, f) {}
  U32 decode() {
    U32 c=0;
    for (int i=0; i<8; ++i)
      c=c+c+e.decode();
    return c;
  }
};

//////////////////////////// main ////////////////////////////

extern "C" int unpaq6(unsigned char *in, int insz, unsigned char *out, int outsz, int levelx) {
    int     c,
            o;

    infile  = in;
    infilel = in + insz;

    MEM = levelx;
    Transformer e(DECOMPRESS, NULL);
    for(o = 0; o < outsz; o++) {
        c = e.decode();
        if(c < 0) break;
        out[o] = c;
    }
    return(o);
}

