// modified by Luigi Auriemma
/* expand.c -- Byte Pair Encoding decompression */
/* Copyright 1996 Philip Gage */

/* Byte Pair Compression appeared in the September 1997
 * issue of C/C++ Users Journal. The original source code
 * may still be found at the web site of the magazine
 * (www.cuj.com).
 *
 * The decompressor has been modified by me (Thiadmer
 * Riemersma) to accept a string as input, instead of a
 * complete file.
 */
//#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
//#include "sc.h"

//#define strexpand_STACKSIZE 16
#define strexpand_STACKSIZE 256 // use more than 16 elements, just in case of "strange" implementations



unsigned char strexpand_table[][128][2] = {
{
  {101,32}, {111,110}, {116,32}, {105,110}, {97,114}, {115,32}, {116,105}, {100,32}, {101,114}, {37,115}, {101,110}, {134,129}, {34,137}, {140,34}, {97,108}, {117,110},
  {114,101}, {110,111}, {97,116}, {115,105}, {121,32}, {97,110}, {111,114}, {109,98}, {115,116}, {32,141}, {100,101}, {41,10}, {109,138}, {145,130}, {101,135}, {139,32},
  {98,108}, {111,108}, {114,97}, {143,99}, {118,142}, {102,163}, {115,121}, {166,151}, {167,161}, {97,32}, {117,115}, {103,32}, {115,147}, {132,162}, {97,160}, {136,32},
  {150,32}, {99,104}, {103,117}, {105,135}, {178,156}, {164,179}, {132,180}, {111,102}, {116,104}, {101,120}, {165,159}, {131,181}, {101,100}, {101,133}, {105,133}, {168,153},
  {154,102}, {118,132}, {183,32}, {105,174}, {193,195}, {116,111}, {173,148}, {109,97}, {99,129}, {101,10}, {115,10}, {112,144}, {116,97}, {182,130}, {98,128}, {152,146},
  {44,32}, {132,97}, {192,131}, {170,130}, {153,10}, {109,146}, {191,155}, {109,211}, {40,214}, {104,97}, {196,128}, {34,32}, {129,32}, {142,32}, {105,99}, {117,108},
  {99,111}, {147,122}, {110,32}, {100,105}, {101,108}, {108,111}, {111,112}, {116,136}, {200,152}, {131,32}, {149,32}, {131,171}, {213,177}, {58,212}, {109,101}, {102,105},
  {100,111}, {97,115}, {108,128}, {118,128}, {230,136}, {232,149}, {204,171}, {203,172}, {215,206}, {119,105}, {109,112}, {110,117}, {185,247}, {165,139}, {251,151}
},{
  {101,32}, {111,110}, {105,110}, {116,32}, {97,114}, {100,32}, {116,105}, {115,32}, {101,114}, {37,115}, {134,129}, {97,108}, {34,137}, {140,34}, {101,110}, {117,110},
  {121,32}, {115,105}, {114,101}, {97,116}, {110,111}, {111,114}, {97,110}, {101,133}, {32,141}, {109,142}, {115,116}, {109,98}, {100,101}, {114,97}, {98,108}, {138,32},
  {143,99}, {102,160}, {111,108}, {148,131}, {118,139}, {132,157}, {115,121}, {166,155}, {167,162}, {117,115}, {97,32}, {105,133}, {115,145}, {149,32}, {165,144}, {103,32},
  {164,171}, {97,158}, {130,176}, {116,104}, {101,120}, {117,153}, {161,159}, {103,181}, {132,183}, {156,102}, {101,100}, {111,102}, {136,32}, {99,104}, {118,132}, {168,152},
  {105,177}, {190,192}, {109,97}, {116,111}, {99,129}, {101,135}, {105,135}, {112,146}, {187,32}, {185,130}, {98,128}, {169,131}, {184,131}, {154,147}, {44,32}, {191,41},
  {109,203}, {40,207}, {105,99}, {130,175}, {115,117}, {145,122}, {193,128}, {109,147}, {58,152}, {34,32}, {129,32}, {139,32}, {104,97}, {100,105}, {101,108}, {110,32},
  {130,32}, {97,99}, {108,111}, {111,112}, {150,131}, {161,138}, {102,149}, {196,154}, {208,202}, {102,105}, {99,111}, {118,128}, {227,136}, {194,144}, {150,32}, {199,172},
  {116,97}, {119,105}, {97,109}, {180,239}, {100,111}, {109,112}, {97,115}, {110,117}, {108,128}, {116,136}, {247,155}, {250,188}, {117,108}, {101,115}, {179,128}
},{
  {105,32}, {114,128}, {112,129}, {46,130}, {49,33}, {37,132}, {32,37}, {97,100}, {115,104}, {117,136}, {112,137}, {46,115}, {32,133}, {108,111}, {59,36}, {141,135},
  {50,33}, {97,108}, {145,116}, {46,146}, {46,112}, {105,33}, {131,133}, {114,33}, {131,37}, {97,151}, {112,153}, {142,154}, {115,116}, {143,139}, {46,99}, {114,149},
  {148,159}, {48,33}, {152,144}, {135,100}, {110,156}, {111,164}, {99,165}, {147,33}, {134,144}, {112,111}, {169,112}, {138,114}, {112,33}, {134,161}, {120,172}, {101,174},
  {142,175}, {134,51}, {138,160}, {170,167}, {147,140}, {157,162}, {126,37}, {134,49}, {177,33}, {103,33}, {104,185}, {99,186}, {120,187}, {163,114}, {46,135}, {122,101},
  {190,114}, {191,114}, {101,113}, {155,138}, {166,150}, {110,100}, {46,149}, {105,110}, {32,35}, {134,52}, {199,99}, {101,99}, {100,203}, {155,171}, {140,176}, {157,150},
  {53,33}, {163,33}, {194,33}, {138,109}, {189,150}, {201,33}, {143,150}, {108,158}, {134,50}, {106,193}, {105,100}, {115,103}, {115,108}, {218,120}, {147,168}, {178,181},
  {117,197}, {136,215}, {111,224}, {98,226}, {114,101}, {228,102}, {193,111}, {227,115}, {180,181}, {183,216}, {217,140}, {143,162}, {231,184}, {179,209}, {108,229}, {183,168},
  {139,140}, {138,158}, {171,109}, {197,33}, {170,160}, {152,161}, {97,243}, {139,173}, {147,173}, {182,50}, {182,51}, {134,48}, {233,177}, {251,183}, {250,182}
},{
  {101,32}, {111,110}, {116,32}, {105,110}, {97,114}, {116,105}, {100,32}, {115,32}, {101,114}, {37,115}, {97,108}, {101,110}, {133,129}, {34,137}, {141,34}, {117,110},
  {114,101}, {115,105}, {110,111}, {97,116}, {121,32}, {111,114}, {97,110}, {32,142}, {109,98}, {115,116}, {100,101}, {109,139}, {98,108}, {101,134}, {140,32}, {143,99},
  {111,108}, {118,138}, {102,159}, {114,97}, {146,130}, {115,121}, {165,152}, {166,160}, {117,115}, {97,32}, {105,134}, {103,32}, {115,145}, {97,156}, {132,163}, {149,32},
  {161,170}, {136,32}, {131,176}, {103,117}, {101,120}, {179,155}, {162,158}, {132,181}, {101,100}, {111,102}, {116,104}, {105,135}, {99,104}, {118,132}, {167,151}, {105,173},
  {189,191}, {154,102}, {116,111}, {99,129}, {174,148}, {185,32}, {109,97}, {101,135}, {112,144}, {183,130}, {98,128}, {153,147}, {44,32}, {190,41}, {40,205}, {168,130},
  {109,207}, {116,97}, {193,131}, {192,128}, {109,147}, {34,32}, {129,32}, {104,97}, {105,99}, {132,97}, {100,105}, {145,122}, {58,151}, {110,32}, {138,32}, {131,171},
  {101,108}, {117,108}, {99,111}, {108,111}, {112,136}, {102,149}, {195,153}, {97,115}, {150,130}, {108,128}, {162,140}, {131,32}, {150,32}, {200,172}, {208,202}, {109,101},
  {111,228}, {102,105}, {119,105}, {180,237}, {109,112}, {111,117}, {110,117}, {118,128}, {116,136}, {198,148}, {246,152}, {111,32}, {209,171}, {250,177}, {115,117}
},{
  {49,33}, {37,128}, {32,129}, {32,37}, {97,100}, {114,105}, {112,133}, {46,134}, {97,108}, {136,116}, {46,137}, {115,104}, {117,139}, {112,140}, {108,111}, {142,132},
  {131,50}, {46,115}, {144,33}, {59,36}, {48,33}, {138,33}, {131,148}, {135,130}, {115,116}, {143,145}, {114,33}, {135,146}, {46,99}, {132,100}, {110,152}, {111,158},
  {99,159}, {97,154}, {112,161}, {147,162}, {135,33}, {112,149}, {111,165}, {112,166}, {138,130}, {112,33}, {120,169}, {101,170}, {147,171}, {141,164}, {131,51}, {46,112},
  {153,155}, {174,33}, {122,101}, {178,114}, {101,113}, {163,141}, {157,114}, {110,100}, {151,173}, {33,167}, {131,49}, {135,150}, {138,150}, {114,101}, {189,102}, {98,111},
  {103,33}, {157,33}, {104,192}, {99,194}, {120,195}, {109,111}, {197,118}, {130,172}, {198,101}, {46,132}, {108,156}, {131,52}, {105,100}, {115,103}, {115,108}, {201,114},
  {204,120}, {106,179}, {138,146}, {184,176}, {117,183}, {139,202}, {191,212}, {214,115}, {200,149}, {168,176}, {179,111}, {143,151}, {215,177}, {108,190}, {209,130}, {180,33},
  {213,135}, {160,151}, {141,156}, {48,48}, {153,151}, {186,146}, {143,155}, {203,33}, {97,183}, {130,181}, {152,111}, {234,114}, {185,193}, {46,98}, {46,105}, {141,114},
  {175,145}, {186,144}, {141,149}, {160,155}, {146,181}, {108,208}, {101,99}, {110,99}, {206,101}, {106,110}, {248,115}, {250,115}, {205,114}, {105,247}, {100,246}
},{
  {101,32}, {111,110}, {116,32}, {105,110}, {97,114}, {116,105}, {100,32}, {115,32}, {101,114}, {101,110}, {133,129}, {97,108}, {37,115}, {34,140}, {141,34}, {117,110}, 
  {114,101}, {110,111}, {115,105}, {97,116}, {121,32}, {97,110}, {111,114}, {109,98}, {32,142}, {100,101}, {115,116}, {109,137}, {41,10}, {101,134}, {138,32}, {98,108}, 
  {145,130}, {111,108}, {114,97}, {143,99}, {118,139}, {102,163}, {115,121}, {166,151}, {167,161}, {117,115}, {97,32}, {115,146}, {97,159}, {132,162}, {103,32}, {136,32}, 
  {150,32}, {103,117}, {105,134}, {177,155}, {164,178}, {132,179}, {111,102}, {101,120}, {165,158}, {131,180}, {99,104}, {116,104}, {105,135}, {153,102}, {101,100}, {118,132}, 
  {168,152}, {182,32}, {105,172}, {191,194}, {101,135}, {173,148}, {109,97}, {116,111}, {99,129}, {115,10}, {112,144}, {116,97}, {181,130}, {98,128}, {154,147}, {44,32}, 
  {40,192}, {132,97}, {169,130}, {189,131}, {152,10}, {101,10}, {208,156}, {109,210}, {195,128}, {34,32}, {129,32}, {139,32}, {104,97}, {105,99}, {100,105}, {146,122}, 
  {109,147}, {110,32}, {101,108}, {117,108}, {99,111}, {108,111}, {111,112}, {116,136}, {200,154}, {58,212}, {102,105}, {97,115}, {108,128}, {230,136}, {232,149}, {149,32}, 
  {202,171}, {131,174}, {203,174}, {215,205}, {119,105}, {109,112}, {183,240}, {110,117}, {118,128}, {165,138}, {247,151}, {198,148}, {102,150}, {111,32}, {131,32}
},{
  {49,33}, {37,128}, {32,129}, {32,37}, {114,105}, {112,132}, {46,133}, {97,100}, {46,97}, {136,108}, {137,116}, {115,104}, {111,135}, {117,139}, {112,141}, {108,140}, 
  {131,50}, {144,33}, {46,115}, {138,33}, {59,36}, {134,130}, {143,146}, {115,116}, {134,145}, {110,151}, {111,153}, {99,154}, {112,147}, {135,100}, {134,33}, {114,33}, 
  {111,156}, {112,160}, {46,99}, {138,130}, {142,158}, {131,51}, {150,152}, {112,33}, {120,167}, {101,168}, {148,169}, {97,159}, {112,171}, {148,172}, {165,33}, {173,142}, 
  {122,101}, {176,114}, {101,113}, {110,100}, {149,164}, {157,114}, {33,161}, {131,49}, {103,33}, {157,33}, {104,184}, {99,186}, {120,187}, {98,111}, {118,101}, {111,190}, 
  {109,191}, {130,170}, {131,52}, {106,177}, {138,145}, {180,166}, {192,147}, {108,162}, {163,166}, {143,149}, {115,174}, {117,179}, {139,199}, {203,202}, {189,205}, {105,100}, 
  {115,103}, {115,108}, {207,120}, {195,130}, {46,135}, {178,33}, {212,114}, {204,134}, {155,149}, {142,162}, {183,145}, {150,149}, {143,152}, {194,33}, {130,175}, {97,179}, 
  {177,111}, {182,185}, {143,46}, {183,144}, {155,152}, {145,175}, {114,101}, {230,102}, {108,231}, {101,115}, {233,115}, {114,116}, {142,147}, {105,33}, {155,163}, {178,130}, 
  {215,32}, {240,50}, {143,196}, {155,197}, {181,197}, {181,200}, {108,210}, {46,98}, {241,225}, {208,235}, {209,234}, {224,158}, {143,163}, {150,163}, {155,200}
},{
  {101,32}, {111,110}, {116,32}, {105,110}, {97,114}, {116,105}, {100,32}, {115,32}, {101,114}, {37,115}, {101,110}, {133,129}, {97,108}, {34,137}, {141,34}, {117,110}, 
  {114,101}, {115,105}, {110,111}, {121,32}, {97,116}, {97,110}, {111,114}, {32,142}, {115,116}, {109,98}, {100,101}, {109,138}, {98,108}, {101,134}, {139,32}, {143,99}, 
  {111,108}, {102,159}, {114,97}, {146,130}, {118,140}, {115,121}, {165,153}, {166,160}, {117,115}, {97,32}, {103,32}, {105,134}, {115,145}, {97,156}, {132,162}, {150,32}, 
  {164,171}, {103,117}, {101,120}, {177,155}, {161,158}, {136,32}, {132,179}, {131,176}, {101,100}, {111,102}, {116,104}, {105,135}, {99,104}, {118,132}, {167,151}, {105,173}, 
  {189,191}, {154,102}, {116,111}, {99,129}, {174,147}, {185,32}, {109,97}, {101,135}, {112,144}, {182,130}, {98,128}, {152,148}, {44,32}, {190,41}, {40,205}, {168,130}, 
  {109,207}, {116,97}, {193,131}, {192,128}, {34,32}, {129,32}, {104,97}, {105,99}, {132,97}, {100,105}, {145,122}, {109,148}, {58,151}, {110,32}, {140,32}, {131,170}, 
  {101,108}, {117,108}, {99,111}, {108,111}, {112,136}, {195,152}, {97,115}, {149,130}, {108,128}, {161,139}, {102,150}, {131,32}, {149,32}, {200,172}, {208,202}, {109,101}, 
  {111,228}, {102,105}, {119,105}, {178,237}, {109,112}, {111,117}, {118,128}, {116,136}, {198,147}, {111,32}, {209,170}, {110,117}, {115,117}, {211,142}, {107,146}
},{
  {49,33}, {37,128}, {32,129}, {32,37}, {97,100}, {114,105}, {112,133}, {46,134}, {97,108}, {136,116}, {46,137}, {115,104}, {108,111}, {117,139}, {112,141}, {140,132}, 
  {131,50}, {46,115}, {144,33}, {59,36}, {138,33}, {48,33}, {131,149}, {115,116}, {135,130}, {143,145}, {135,146}, {114,33}, {46,99}, {132,100}, {110,151}, {111,158}, 
  {99,159}, {112,148}, {135,33}, {97,155}, {112,163}, {147,164}, {111,161}, {112,166}, {138,130}, {112,33}, {120,169}, {101,170}, {147,171}, {142,162}, {131,51}, {153,154}, 
  {46,112}, {174,33}, {122,101}, {101,113}, {178,114}, {165,142}, {110,100}, {157,114}, {152,173}, {33,167}, {131,49}, {135,150}, {138,150}, {114,101}, {189,102}, {98,111}, 
  {103,33}, {157,33}, {104,192}, {99,194}, {120,195}, {109,111}, {197,118}, {130,172}, {198,101}, {108,156}, {131,52}, {105,100}, {115,103}, {115,108}, {203,120}, {106,180}, 
  {138,146}, {184,175}, {117,182}, {139,201}, {191,210}, {212,115}, {46,132}, {200,148}, {168,175}, {214,114}, {143,152}, {213,177}, {108,190}, {180,111}, {207,130}, {179,33}, 
  {211,135}, {142,156}, {160,152}, {186,146}, {143,154}, {153,152}, {202,33}, {130,181}, {97,182}, {151,111}, {233,114}, {185,193}, {46,98}, {46,105}, {186,144}, {176,145}, 
  {142,148}, {160,154}, {48,48}, {146,181}, {108,206}, {101,99}, {110,99}, {205,101}, {106,110}, {247,115}, {249,115}, {204,114}, {100,245}, {105,246}, {251,116}  
},{
  {32,37}, {114,105}, {112,129}, {46,130}, {49,33}, {128,132}, {97,100}, {46,97}, {135,108}, {136,116}, {111,134}, {108,138}, {50,33}, {115,104}, {128,140}, {137,33}, 
  {46,115}, {117,141}, {112,145}, {131,133}, {139,144}, {112,143}, {131,142}, {115,116}, {111,149}, {112,152}, {131,33}, {134,100}, {110,151}, {111,156}, {99,157}, {59,36}, 
  {146,154}, {148,150}, {112,33}, {120,162}, {101,163}, {159,164}, {137,133}, {46,99}, {122,101}, {110,100}, {155,114}, {101,113}, {168,114}, {147,160}, {51,33}, {128,174}, 
  {103,33}, {133,165}, {104,176}, {99,178}, {120,179}, {171,33}, {106,172}, {173,161}, {155,33}, {108,167}, {117,169}, {115,175}, {186,187}, {153,184}, {141,185}, {111,188}, 
  {98,191}, {105,100}, {115,103}, {115,108}, {193,120}, {182,133}, {114,33}, {166,161}, {190,131}, {137,142}, {169,33}, {97,202}, {139,147}, {172,111}, {158,147}, {139,150}, 
  {105,33}, {101,115}, {209,115}, {114,116}, {148,147}, {171,133}, {189,139}, {32,140}, {146,167}, {196,170}, {158,183}, {170,183}, {199,192}, {108,196}, {97,198}, {194,211}, 
  {46,208}, {195,210}, {200,215}, {112,222}, {159,227}, {46,98}, {118,101}, {111,230}, {109,231}, {146,143}, {99,144}, {158,150}, {97,149}, {203,153}, {52,33}, {225,33}, 
  {158,166}, {194,181}, {195,181}, {201,180}, {223,198}, {153,203}, {214,224}, {100,101}, {128,238}, {119,236}, {249,237}, {105,110}, {115,250}, {232,143}, {205,154}
},{
  {101,32}, {116,32}, {111,110}, {105,110}, {97,114}, {100,32}, {105,130}, {101,114}, {101,110}, {115,32}, {97,108}, {97,116}, {117,110}, {115,34}, {37,141}, {34,142}, 
  {109,136}, {121,32}, {97,110}, {114,101}, {99,116}, {134,32}, {110,111}, {101,133}, {118,138}, {115,105}, {98,108}, {111,114}, {115,116}, {41,10}, {109,98}, {100,101}, 
  {117,115}, {150,129}, {102,140}, {117,144}, {162,148}, {103,163}, {132,165}, {114,97}, {105,133}, {152,168}, {99,104}, {32,143}, {97,32}, {131,169}, {97,115}, {164,149}, 
  {111,108}, {101,120}, {97,154}, {135,32}, {132,167}, {111,102}, {105,116}, {166,129}, {101,100}, {98,128}, {178,128}, {160,129}, {105,137}, {180,145}, {121,158}, {190,176}, 
  {109,187}, {115,191}, {118,132}, {101,10}, {115,10}, {112,147}, {155,32}, {181,32}, {159,102}, {194,105}, {99,130}, {103,32}, {201,186}, {116,111}, {34,32}, {109,97}, 
  {153,122}, {171,10}, {104,97}, {100,105}, {108,111}, {111,112}, {200,131}, {139,134}, {213,135}, {101,137}, {202,156}, {143,157}, {138,32}, {192,185}, {58,209}, {105,99}, 
  {112,111}, {115,115}, {110,117}, {115,117}, {146,129}, {226,158}, {229,179}, {177,197}, {231,225}, {132,97}, {98,101}, {99,111}, {216,139}, {109,139}, {116,10}, {99,146}, 
  {44,32}, {237,170}, {131,203}, {116,104}, {117,108}, {152,117}, {108,128}, {118,128}, {101,144}, {233,148}, {174,153}, {110,32}, {131,32}, {146,32}, {239,161}
},{
  {101,32}, {111,110}, {116,32}, {105,110}, {97,114}, {116,105}, {100,32}, {115,32}, {101,114}, {37,115}, {97,108}, {101,110}, {133,129}, {34,137}, {141,34}, {117,110},
  {114,101}, {110,111}, {115,105}, {121,32}, {97,116}, {111,114}, {97,110}, {32,142}, {109,98}, {115,116}, {41,10}, {100,101}, {109,139}, {101,134}, {98,108}, {140,32},
  {111,108}, {114,97}, {145,130}, {118,138}, {143,99}, {102,164}, {115,121}, {166,152}, {167,160}, {117,115}, {97,32}, {115,146}, {97,158}, {149,32}, {132,161}, {105,134},
  {103,32}, {136,32}, {163,175}, {103,117}, {179,156}, {131,178}, {132,180}, {111,102}, {116,104}, {101,120}, {105,135}, {165,159}, {101,100}, {99,104}, {118,132}, {168,151},
  {105,172}, {190,192}, {155,102}, {174,147}, {183,32}, {109,97}, {116,111}, {99,129}, {101,135}, {112,144}, {182,130}, {98,128}, {115,10}, {153,148}, {44,32}, {40,191},
  {169,130}, {151,10}, {101,10}, {207,154}, {109,208}, {116,97}, {194,131}, {193,128}, {34,32}, {129,32}, {105,99}, {132,97}, {100,105}, {146,122}, {110,32}, {138,32},
  {104,97}, {101,108}, {117,108}, {99,111}, {108,111}, {109,148}, {199,153}, {58,209}, {111,112}, {97,115}, {108,128}, {232,136}, {230,150}, {150,32}, {201,171}, {131,176},
  {212,203}, {102,105}, {119,105}, {185,238}, {109,112}, {116,136}, {165,140}, {197,147}, {102,149}, {111,32}, {131,32}, {213,176}, {110,117}, {115,117}, {118,128}
},{
  {49,33}, {37,128}, {32,129}, {32,37}, {114,105}, {112,132}, {46,133}, {97,100}, {46,97}, {136,108}, {137,116}, {115,104}, {111,135}, {117,139}, {112,141}, {108,140},
  {131,50}, {144,33}, {46,115}, {59,36}, {138,33}, {134,130}, {143,146}, {134,145}, {115,116}, {114,33}, {110,152}, {111,154}, {99,155}, {112,148}, {135,100}, {134,33},
  {97,153}, {112,160}, {147,161}, {111,157}, {112,163}, {46,99}, {138,130}, {142,159}, {131,51}, {150,151}, {112,33}, {120,170}, {101,171}, {147,172}, {168,33}, {162,142},
  {101,113}, {110,100}, {122,101}, {178,114}, {149,167}, {158,114}, {33,164}, {131,49}, {103,33}, {158,33}, {104,184}, {99,186}, {120,187}, {98,111}, {118,101}, {111,190},
  {109,191}, {130,173}, {131,52}, {115,103}, {115,108}, {138,145}, {180,169}, {192,148}, {108,165}, {166,169}, {143,149}, {115,174}, {117,177}, {204,203}, {139,200}, {189,205},
  {105,100}, {208,120}, {46,135}, {176,33}, {106,179}, {210,114}, {206,134}, {156,149}, {142,165}, {183,145}, {143,151}, {150,149}, {194,33}, {130,175}, {97,177}, {179,111},
  {212,130}, {182,185}, {143,46}, {183,144}, {156,151}, {145,175}, {114,101}, {230,102}, {196,101}, {108,231}, {232,115}, {234,115}, {195,114}, {236,116}, {142,148}, {105,33},
  {176,130}, {214,32}, {156,166}, {241,50}, {156,198}, {181,198}, {143,197}, {181,201}, {108,209}, {46,98}, {243,225}, {106,110}, {237,153}, {223,159}, {143,166}
},{
    {0,0}
}
};




int strexpand(unsigned char *dest, unsigned char *source, int sourcelen, int maxlen, unsigned char *input_pairtable, int input_pairtable_default) {
    unsigned char pairtable[128][2];

  unsigned char stack[strexpand_STACKSIZE];
  short c, top = 0;
  int len = 0;
  unsigned char *sourcel = source + sourcelen;
  int tables;

  if(input_pairtable) {
    memcpy(pairtable, input_pairtable, sizeof(pairtable));
  } else {
    for(tables = 0; strexpand_table[tables] && strexpand_table[tables][0][0] && strexpand_table[tables][0][1]; tables++);
    input_pairtable_default--;  // table number to C array (1 is the first = 0)
    if(input_pairtable_default < 0) {
        memcpy(pairtable, source, sizeof(pairtable));
        source += sizeof(pairtable);
    } else if(input_pairtable_default >= tables) {
        printf("\nError: your number (%d) is greater than the embedded SCPACK tables (%d)\n", input_pairtable_default, tables);
        return -1;
    } else {
        memcpy(pairtable, strexpand_table[input_pairtable_default], sizeof(pairtable));
    }
  }

  //assert(maxlen > 0);
  if(maxlen == 0) return(0);
  if(maxlen < 0) return(-1);
  len = 0;
  //len = 1;              /* already 1 byte for '\0' */
  for (;;) {

    /* Pop byte from stack or read byte from the input string */
    if (top)
      c = stack[--top];
    else {
        if(source >= sourcel) break;
        c = *(unsigned char *)source++;
    }

    /* Push pair on stack or output byte to the output string */
    if (c > 127) {
      //assert(top+2 <= strexpand_STACKSIZE);
      if(top+2 > strexpand_STACKSIZE) return(-1);
      stack[top++] = pairtable[c-128][1];
      stack[top++] = pairtable[c-128][0];
    }
    else {
      if(len >= maxlen) break; //return(-1);
      *dest++ = (char)c;
      len++;
      //if (maxlen > 1) { /* reserve one byte for the '\0' */
        //*dest++ = (char)c;
        //maxlen--;
      //}
    }
  }
  //*dest = '\0';
  return len;           /* return number of bytes decoded */
}

