// modified by Luigi Auriemma
/* crypt.h -- base code for crypt/uncrypt ZIPfile


   Version 1.01e, February 12th, 2005

   Copyright (C) 1998-2005 Gilles Vollant

   This code is a modified version of crypting code in Infozip distribution

   The encryption/decryption parts of this source code (as opposed to the
   non-echoing password parts) were originally written in Europe.  The
   whole source package can be freely distributed, including from the USA.
   (Prior to January 2000, re-export from the US was a violation of US law.)

   This encryption code is a direct transcription of the algorithm from
   Roger Schlafly, described by Phil Katz in the file appnote.txt.  This
   file (appnote.txt) is distributed with the PKZIP program (even in the
   version without encryption capabilities).

   If you don't need crypting in your application, just define symbols
   NOCRYPT and NOUNCRYPT.

   This code support the "Traditional PKWARE Encryption".

   The new AES encryption added on Zip format by Winzip (see the page
   http://www.winzip.com/aes_info.htm ) and PKWare PKZip 5.x Strong
   Encryption is not supported.
*/

#define CRC32(c, b) ((*(pcrc_32_tab+(((int)(c) ^ (b)) & 0xff))) ^ ((c) >> 8))

/***********************************************************************
 * Return the next byte in the pseudo-random sequence
 */
static int zipcrypto_decrypt_byte(uint32_t* pkeys, const uint32_t* pcrc_32_tab)
{
    uint32_t temp;  /* POTENTIAL BUG:  temp*(temp^1) may overflow in an
                     * unpredictable manner on 16-bit systems; not a problem
                     * with any known compiler so far, though */

    temp = ((uint32_t)(*(pkeys+2)) & 0xffff) | 2;
    return (int)(((temp * (temp ^ 1)) >> 8) & 0xff);
}

/***********************************************************************
 * Update the encryption keys with the next byte of plain text
 */
static int zipcrypto_update_keys(uint32_t* pkeys,const uint32_t* pcrc_32_tab,int c)
{
    (*(pkeys+0)) = CRC32((*(pkeys+0)), c);
    (*(pkeys+1)) += (*(pkeys+0)) & 0xff;
    (*(pkeys+1)) = (*(pkeys+1)) * 134775813L + 1;
    {
      register int keyshift = (int)((*(pkeys+1)) >> 24);
      (*(pkeys+2)) = CRC32((*(pkeys+2)), keyshift);
    }
    return c;
}


/***********************************************************************
 * Initialize the encryption keys and the random header according to
 * the given password.
 */
static void zipcrypto_init_keys(const char* passwd,uint32_t* pkeys,const uint32_t* pcrc_32_tab)
{
    *(pkeys+0) = 305419896L;
    *(pkeys+1) = 591751049L;
    *(pkeys+2) = 878082192L;
    while (*passwd != '\0') {
        zipcrypto_update_keys(pkeys,pcrc_32_tab,(int)*passwd);
        passwd++;
    }
}

#define zdecode(pkeys,pcrc_32_tab,c) \
    (zipcrypto_update_keys(pkeys,pcrc_32_tab,c ^ zipcrypto_decrypt_byte(pkeys,pcrc_32_tab)))    // ^= was useless

#define zencode(pkeys,pcrc_32_tab,c,t) \
    (t=zipcrypto_decrypt_byte(pkeys,pcrc_32_tab), zipcrypto_update_keys(pkeys,pcrc_32_tab,c), t^(c))

void zipcrypto_decrypt(uint32_t* pkeys,const uint32_t* pcrc_32_tab, unsigned char *data, int datalen) {
    int     i;
    for(i = 0; i < datalen; i++) {
        data[i] = zdecode(pkeys, pcrc_32_tab, data[i]);
    }
}

void zipcrypto_encrypt(uint32_t* pkeys,const uint32_t* pcrc_32_tab, unsigned char *data, int datalen) {
    int     i,
            t;
    for(i = 0; i < datalen; i++) {
        data[i] = zencode(pkeys, pcrc_32_tab, data[i], t);
    }
}
